BEM.MODEL.decl({ model: 'm-banner', baseModel: 'dm-base-banner' }, {
    cid: { type: 'string', internal: true },

    vcard_id: 'string',

    //DIRECT-38584 ключевые слова на баннер deprecated - оставлено для совместимости с виртуальными визитками
    splited_phrases: 'string',

    adgroup_id: { type: 'string', internal: true },

    //следующие 2 статуса дублируются из m-campaign на все баннеры кампании, чтобы не таскать модель кампании ради
    // одного флага
    statusOpenStat: { type: 'flag', internal: true },
    status_click_track: { type: 'boolean', internal: true },

    isTemplateBanner: { type: 'boolean', internal: true },

    age: { type: 'number', precision: 0 }, // ограничение по возрасту, с сервера приходит как hash_flags.age
    ageInstalled: { type: 'boolean', internal: true },

    // поле с предупреждениями из модерации
    // нужно для отрисовки предупреждений в превью на клиенте, в цепочке:
    // запрос за данными баннера -> построение модели -> отрисовка првеью
    hash_flags: { type: 'extended-object' },

    disclaimer: { type: 'string' },

    title: {
        type: 'string',
        validation: {
            rules: {
                required: { text: iget2('m-banner', 'neobhodimo-ukazat-zagolovok', 'Необходимо указать заголовок') },
                noLongWords: {
                    validate: function(val) {
                        // Увеличение лимита на 1 требуется чтобы слово длинной 23 символа было валидным
                        // т.к. регулярное выражение подразумевает логику >=
                        var maxUniLength = u.consts('MAX_TITLE_UNINTERRUPTED_LENGTH') + 1;

                        return !(new RegExp('[а-яА-ЯёЁA-Za-z0-9_]{' + maxUniLength + ',}').test(val));
                    },
                    text: function(val) {
                        return u.pluralForms(
                            iget2(
                                'm-banner',
                                'v-zagolovke-1-nedopustimy',
                                'В Заголовке 1 недопустимы слова длиной более {foo} {символа|символов|символов}. Слишком длинные слова: «{bar}».',
                                {
                                    foo: u.consts('MAX_TITLE_UNINTERRUPTED_LENGTH'),
                                    bar: val
                                }
                            ),
                            u.consts('MAX_TITLE_UNINTERRUPTED_LENGTH'));
                    }
                },
                tooLong: {
                    validate: function(val) {
                        var title = u.preview.skipSharpSign(val),
                            titleLengthCounter = u.preview.strCounterWithoutNarrow(
                                title,
                                u.consts('NEW_MAX_TITLE_LENGTH'),
                                ''
                            );

                        return titleLengthCounter >= 0;
                    },
                    text: function() {
                        return iget2('m-banner', 'prevyshena-dopustimaya-dlina-zagolovka', 'Превышена допустимая длина заголовка в {text}', {
                            text: u.pluralize([
                                iget2('m-banner', 'simvol', 'символ'),
                                iget2('m-banner', 'simvola', 'символа'),
                                iget2('m-banner', 'simvolov', 'символов'),
                                iget2('m-banner', 'simvolov', 'символов')
                            ], u.consts('NEW_MAX_TITLE_LENGTH'))
                        })
                    }
                },
                maxNarrow: {
                    validate: function(val) {
                        var narrowSymbolsRegExp = new RegExp('([' + u.consts('NARROW_SYMBOLS') + '])', 'g'),
                            title = u.preview.skipSharpSign(val),
                            narrowsLength = ((title || '').match(narrowSymbolsRegExp) || '').length;

                        return narrowsLength <= u.consts('MAX_NUMBER_OF_NARROW_CHARACTERS');
                    },
                    text: iget2(
                        'm-banner',
                        'v-zagolovke-1-vy',
                        'В Заголовке 1 вы можете использовать не более {foo} точек, запятых, двоеточий, точек с запятой, кавычек и восклицательных знаков',
                        {
                            foo: u.consts('MAX_NUMBER_OF_NARROW_CHARACTERS')
                        }
                    )
                },
                noInvalidSymbols: {
                    validate: function(val) {
                        // eslint-disable-next-line max-len
                        return !(new RegExp('[^' + u.consts('ALLOW_BANNER_LETTERS').replace(/\\/g, '').replace(/[.?*+^$[\]\\(){}|-]/g, '\\$&') + '\\\\]').test(val));
                    },
                    text: iget2(
                        'm-banner',
                        'v-zagolovke-1-mozhno',
                        'В Заголовке 1 можно использовать только буквы латинского, турецкого, русского, украинского, казахского или белорусского алфавита, цифры и знаки пунктуации'
                    )
                }

            },
            needToValidate: function() {
                return this.get('ad_type') === 'text';
            }
        },
        format: u.preview.prettifyText
    },

    title_extension: {
        type: 'string',
        validation: {
            rules: {
                noLongWords: {
                    validate: function(val) {
                        // Увеличение лимита на 1 требуется чтобы слово длинной 22 символа было валидным
                        // т.к. регулярное выражение подразумевает логику >=
                        var maxUniLength = u.consts('MAX_TITLE_UNINTERRUPTED_LENGTH') + 1;

                        return !(new RegExp('[а-яА-ЯёЁA-Za-z0-9_]{' + maxUniLength + ',}').test(val));
                    },
                    text: function(val) {
                        return u.pluralForms(
                            iget2(
                                'm-banner',
                                'v-zagolovke-2-nedopustimy',
                                'В Заголовке 2 недопустимы слова длиной более {foo} {символа|символов|символов}. Слишком длинные слова: «{bar}».',
                                {
                                    foo: u.consts('MAX_TITLE_UNINTERRUPTED_LENGTH'),
                                    bar: val
                                }
                            ),
                            u.consts('MAX_TITLE_UNINTERRUPTED_LENGTH'));
                    }
                },
                tooLong: {
                    validate: function(val) {
                        var titleExt = u.preview.skipSharpSign(val),
                            titleLengthCounter = u.preview.strCounterWithoutNarrow(
                                titleExt,
                                u.consts('MAX_TITLE_EXTENSION_LENGTH'),
                                u.consts('NARROW_SYMBOLS')
                            );

                        return titleLengthCounter >= 0;
                    },
                    text: iget2('m-banner', 'prevyshena-dopustimaya-dlina-zagolovka', 'Превышена допустимая длина заголовка в {text}', {
                        text: u.pluralize([
                            iget2('m-banner', 'simvol', 'символ'),
                            iget2('m-banner', 'simvola', 'символа'),
                            iget2('m-banner', 'simvolov', 'символов'),
                            iget2('m-banner', 'simvolov', 'символов')
                        ], u.consts('MAX_TITLE_EXTENSION_LENGTH'))
                    })
                },
                maxNarrow: {
                    validate: function(val) {
                        var narrowSymbolsRegExp = new RegExp('([' + u.consts('NARROW_SYMBOLS') + '])', 'g'),
                            titleExt = u.preview.skipSharpSign(val),
                            narrowsLength = ((titleExt || '').match(narrowSymbolsRegExp) || '').length;

                        return narrowsLength <= u.consts('MAX_NUMBER_OF_NARROW_CHARACTERS');
                    },
                    text: iget2(
                        'm-banner',
                        'v-zagolovke-2-vy',
                        'В Заголовке 2 вы можете использовать не более {foo} точек, запятых, двоеточий, точек с запятой, кавычек и восклицательных знаков',
                        {
                            foo: u.consts('MAX_NUMBER_OF_NARROW_CHARACTERS')
                        }
                    )
                },
                noInvalidSymbols: {
                    validate: function(val) {
                        // eslint-disable-next-line max-len
                        return !(new RegExp('[^' + u.consts('ALLOW_BANNER_LETTERS').replace(/\\/g, '').replace(/[.?*+^$[\]\\(){}|-]/g, '\\$&') + '\\\\]').test(val));
                    },
                    text: iget2(
                        'm-banner',
                        'v-zagolovke-2-mozhno',
                        'В Заголовке 2 можно использовать только буквы латинского, турецкого, русского, украинского, казахского или белорусского алфавита, цифры и знаки пунктуации'
                    )
                }
            },
            needToValidate: function() {
                return this.get('ad_type') === 'text';
            }
        },
        format: u.preview.prettifyText
    },

    body: {
        type: 'string',
        validation: {
            rules: {
                required: {
                    text: iget2('m-banner', 'neobhodimo-ukazat-tekst-obyavleniya', 'Необходимо указать текст объявления')
                },
                noLongWords: {
                    validate: function(val) {
                        // Увеличение лимита на 1 требуется чтобы слово длинной 23 символа было валидным
                        // т.к. регулярное выражение подразумевает логику >=
                        var maxUniLength = u.consts('MAX_BODY_UNINTERRUPTED_LENGTH') + 1;

                        return !(new RegExp('[а-яА-ЯёЁA-Za-z0-9_]{' + maxUniLength + ',}').test(val));
                    },
                    text: function(val) {
                        return u.pluralForms(
                            iget2(
                                'm-banner',
                                'v-reklamnom-tekste-nedopustimy',
                                'В рекламном тексте недопустимы слова длиной более {foo} {символа|символов|символов}. Слишком длинные слова: «{bar}».',
                                {
                                    foo: u.consts('MAX_BODY_UNINTERRUPTED_LENGTH'),
                                    bar: val
                                }
                            ),
                            u.consts('MAX_BODY_UNINTERRUPTED_LENGTH'));
                    }
                },
                tooLong: {
                    validate: function(val) {
                        var body = u.preview.skipSharpSign(val),
                            bodyLengthCounter = u.preview.strCounterWithoutNarrow(
                                body,
                                +u.consts('MAX_BODY_LENGTH'),
                                u.consts('NARROW_SYMBOLS')
                            );

                        return bodyLengthCounter >= 0;
                    },
                    text: iget2('m-banner', 'prevyshena-dopustimaya-dlina-teksta', 'Превышена допустимая длина текста объявления в {text}', {
                        text: u.pluralize([
                            iget2('m-banner', 'simvol', 'символ'),
                            iget2('m-banner', 'simvola', 'символа'),
                            iget2('m-banner', 'simvolov', 'символов'),
                            iget2('m-banner', 'simvolov', 'символов')
                        ], +u.consts('MAX_BODY_LENGTH'))
                    })
                },
                maxNarrow: {
                    validate: function(val) {
                        var narrowSymbolsRegExp = new RegExp('([' + u.consts('NARROW_SYMBOLS') + '])', 'g'),
                            body = u.preview.skipSharpSign(val),
                            narrowsLength = ((body || '').match(narrowSymbolsRegExp) || '').length;

                        return narrowsLength <= u.consts('MAX_NUMBER_OF_NARROW_CHARACTERS');
                    },
                    text: iget2(
                        'm-banner',
                        'v-reklamnom-tekste-vy',
                        'В рекламном тексте вы можете использовать не более {foo} точек, запятых, двоеточий, точек с запятой, кавычек и восклицательных знаков',
                        {
                            foo: u.consts('MAX_NUMBER_OF_NARROW_CHARACTERS')
                        }
                    )
                },
                noInvalidSymbols: {
                    validate: function(val) {
                        // eslint-disable-next-line max-len
                        return !(new RegExp('[^' + u.consts('ALLOW_BANNER_LETTERS').replace(/\\/g, '').replace(/[.?*+^$[\]\\(){}|-]/g, '\\$&') + '\\\\]').test(val));
                    },
                    text: iget2(
                        'm-banner',
                        'v-tekste-reklamnogo-soobshcheniya',
                        'В тексте рекламного сообщения можно использовать только буквы латинского, турецкого, русского, украинского, казахского или белорусского алфавита, цифры и знаки пунктуации'
                    )
                }
            },
            needToValidate: function() {
                return this.get('ad_type') === 'text';
            }
        },
        format: u.preview.prettifyText,
        preprocess: function(value) {
            return typeof value === 'string' ? value.replace('\n', ' ') : value;
        }
    },

    href_model: {
        type: 'model',
        modelName: 'm-banner-href',
        validation: {
            rules: {
                deep: {
                    text: function(model) {
                        return model.validate().errors
                            .map(function(error) { return error.text; })
                            .join('\n');
                    }
                }
            },
            needToValidate: function() {
                return this.get('has_site') && ( !this.get('has_vcard') || this.get('isVCardEmpty') ||
                    (!!this.get('display_href')) || this.get('ad_type') !== 'image_ad');
            }
        },
        value: {}
    },

    //Уточнения
    callouts: { type: 'array' },

    display_domain: {
        type: 'string',
        internal: true,
        calculate: function() {
            var hrefModel = this.get('href_model');
            return hrefModel.get('domain') || u.extractDomain(hrefModel.get('href'));
        },
        dependsFrom: ['href_model'],
        format: u.escapeHTML
    },

    has_display_domain: {
        type: 'boolean',
        internal: true,
        calculate: function() {
            return !!this.get('display_domain');
        },
        dependsFrom: ['display_domain']
    },

    // Отображаемая ссылка
    display_href: {
        type: 'string',
        validation: {
            rules: {
                'href-length': {
                    validate: function(value) {
                        return !value || u.preview.skipSharpSign(value).length <= 20;
                    },
                    text: iget2('m-banner', 'otobrazhaemaya-ssylka-dolzhna-byt', 'Отображаемая ссылка должна быть не более 20 символов')
                },
                noTurbo: {
                    validate: function() {
                        return !u['turbo'].isLinkTurbo(this.get('display_domain') + '/' + this.get('display_href'))
                    },
                    text: iget2('m-banner', 'no-turbolanding-url', 'Нельзя указывать ссылку на турбо-страницу')
                }
            },
            needToValidate: function() {
                return this.get('ad_type') === 'text';
            }
        },
        format: u.preview.prettifyDisplayHref
    },

    sitelinks: {
        type: 'model',
        modelName: 'm-banner-sitelinks',
        validation: {
            rules: {
                'href-required': {
                    validate: function() {
                        return !(this.get('href_model').isEmpty('href') && !this.get('sitelinks').isEmpty());
                    },

                    text: iget2(
                        'm-banner',
                        'esli-zapolneny-bystrye-ssylki',
                        'Если заполнены быстрые ссылки, то должна быть заполнена основная ссылка на сайт'
                    )
                }
            },
            needToValidate: function() {
                return this.get('ad_type') === 'text' && this.get('has_site');
            }
        }
    },

    image_model: {
        type: 'model',
        modelName: 'm-banner-pic',
        validation: {
            rules: {
                tooEarly: {
                    validate: function() {
                        return !this.get('image_model').isImageProcessing();
                    },
                    text: iget2('m-banner', 'neobhodimo-dozhdatsya-okonchaniya-obrabotki', 'Необходимо дождаться окончания обработки изображения')
                }
            },
            needToValidate: function() {
                return this.get('ad_type') === 'text';
            }
        }
    },

    // данные медиа дополнений для баннера
    video_resources: {
        type: 'extended-object'
    },

    // язык баннера (для последующей передачи в pcode)
    lang: 'string',

    // для баннера запрещены видеодополнения по умолчанию
    disable_videomotion: {
        type: 'boolean',
        default: false
    },

    ad_type: {
        type: 'enum',
        default: 'text',
        enum: [
            'text',
            'image_ad',
            'cpc_video',
            'mcbanner'
        ]
    },

    image_ad: {
        type: 'model',
        modelName: 'dm-image-ad',
        validation: {
            rules: {
                'ad-required': {
                    text: iget2('m-banner', 'neobhodimo-zagruzit-kreativ', 'Необходимо загрузить креатив'),
                    validate: function() {
                        var image = this.get('image_ad'),
                            creative = this.get('creative');

                        return !!((creative && creative.get('creative_id')) || (image && image.get('hash')));
                    }
                }
            },
            needToValidate: function() {
                return this.get('ad_type') === 'image_ad' || this.get('ad_type') === 'mcbanner';
            }
        }
    },

    creative: {
        type: 'model',
        modelName: 'dm-creative',
        validation: {
            rules: {
                'ad-required': {
                    text: iget2('m-banner', 'neobhodimo-zagruzit-kreativ', 'Необходимо загрузить креатив'),
                    validate: function() {
                        var creative = this.get('creative');

                        return !!(creative && creative.get('creative_id'));
                    }
                }
            },
            needToValidate: function() {
                return this.get('ad_type') === 'cpc_video';
            }
        }
    },

    turbolanding: {
        type: 'model',
        modelName: 'dm-turbo-landing',
        validation: {
            rules: {
                'turbolanding-required': {
                    text: iget2('m-banner', 'turbolanding-required', 'Необходимо выбрать Турбо-страницу'),
                    validate: function() {
                        var turbo = this.get('turbolanding');

                        return !!(+turbo.get('id'));
                    }
                }
            },
            needToValidate: function() {
                return !this.get('has_site');
            }
        },
        internal: true
    },

    turbolandingIsActive: {
        type: 'boolean',
        default: false,
        internal: true
    },

    turboRecommendationIsFetching: {
        type: 'boolean',
        default: false
    },

    turboRecommendation: {
        type: 'model',
        modelName: 'dm-turbo-recommendation',
    },

    turbolanding_href_params: {
        type: 'string',
        validation: {
            rules: {
                maxLength: {
                    value: u.consts('MAX_URL_LENGTH'),
                    text: u.pluralForms(
                        iget2(
                            'm-banner',
                            'error-message-max-length',
                            'Превышена максимальная длина строки параметров ссылки, {maxLength} {символ|символа|символов}.',
                            { maxLength: u.consts('MAX_URL_LENGTH') }),
                        u.consts('MAX_URL_LENGTH')),
                    needToValidate: function(val) {
                        return !!val
                    }
                }
            }
        }
    },

    vcard: {
        type: 'extended-object',
        // раньше vcard был глупым объектом, и при отсутствии значения был undefined
        // и во многих местах есть проверка !!model.get('vcard')
        preprocess: function(value) {
            return u._.isEmpty(value) ? undefined : value;
        }
    },

    // баннер содержит цену
    banner_price: {
        type: 'model',
        modelName: 'm-banner-price',
    },

    //баннер содержит визитку
    has_vcard: {
        type: 'number',
        calculate: function() {
            if (this.get('ad_type') === 'image_ad' || this.get('ad_type') === 'cpc_video') {
                return 0;
            }

            return this.get('isVCardEmpty') || !this.get('is_vcard_open') ? 0 : 1
        },
        dependsFrom: ['isVCardEmpty', 'is_vcard_open', 'ad_type']
    },
     //баннер содержит урл
    has_href: {
        type: 'number',
        calculate: function() {
            return this.get('has_href_only') || !this.get('has_vcard') ? 1 : 0
        },
        dependsFrom: ['has_href_only', 'has_vcard']
    },
    //баннер содержит урл
    has_href_only: {
        type: 'boolean',
        calculate: function() {
            return !!this.get('href_model').get('href');
        },
        dependsFrom: ['href_model', 'ad_type'],
        internal: true
    },
    //состояние toggle да/нет на Укажите адрес для показа объявления на Яндекс.Картах
    is_vcard_open: {
        type: 'number',
        preprocess: function(val) {
            if (!val) return 0;

            return (+val);
        },
        default: 0
    },
    //состояние link скрыть/показать
    is_vcard_collapsed: {
        type: 'boolean',
        default: false
    },

    isVCardEmpty: { type: 'boolean', internal: true },

    geo_names: 'string',
    declined_show: 'boolean',
    child_age: { type: 'number', value: 11 },

    baby_food_enabled: 'boolean',
    is_template_banner: 'boolean',
    domain: 'string',
    //для показа визитки в новом окне нужно
    // использовать предварительно сформированные стабы визитки на сервере
    loadVCardFromClient: 'boolean',

    //---Модерация
    //Баннер скопирован в оптимизированные
    isStatusOptimized: 'boolean',
    //Баннер отклонен модератором
    isRejectByModerator: 'boolean',
    enable: 'boolean',
    //----

    //имя группы, к которой принадлежит баннер DIRECT-38629
    group_name: 'string',

    canToggleAge: 'boolean',

    //идет создание нового баннера
    newBannerIndex: { type: 'number' },
    //имеет ссылку "скопировать из предыдущего"
    hasCopyFromPrev: { type: 'boolean', internal: true },

    /**
     * Заголовок и текст объявления до автоисправления в модерации
     * @param {Object} before_moderation
     * @param {String} before_moderation.title
     * @param {String} before_moderation.body
     * @param {'Yes'|'No'} before_moderation.showModEditNotice Флаг о показе версии до исправления опечаток
     */
    before_moderation: {
        type: 'object'
    },

    // enum нужен для радиокнопки
    has_site_enum: {
        type: 'enum',
        enum: ['yes', 'no'],
        internal: true
    },

    // это поле будем использовать в коде
    has_site: {
        type: 'boolean',
        internal: true,
        calculate: function() {
            return this.get('has_site_enum') === 'yes';
        },
        dependsFrom: ['has_site_enum']
    },

    // ID организации справочника
    permalink: 'string',

    prefer_vcard_over_permalink: 'boolean'

}, {
    /**
     * Извлекает данные из модели баннера
     * @returns {Object}
     */
    provideData: function() {
        var hrefObject = this.get('href_model').toJSON(),
            imageObject = this.get('image_model').toJSON(),
            turbolanding = this.get('turbolanding').provideData(),
            data = this.toJSON(),
            shouldClearTurbo;

        if (data.ad_type === 'image_ad' || data.ad_type === 'cpc_video') {
            delete data.sitelinks;
        } else {
            data.sitelinks = this.get('sitelinks').provideData();
        }

        if (!data.has_vcard) {
            delete data.vcard;
            delete data.vcard_id;
        }

        if (!data.banner_price.price) {
            delete data.banner_price;
        }

        Object.keys(hrefObject).forEach(function(key) {
            data[key] = hrefObject[key];
        });

        if (!this.get('has_site')) {
            data.href = '';
            delete data.display_href;
        }

        Object.keys(imageObject).forEach(function(key) {
            data[key] = imageObject[key];
        });

        //ageInstalled может быть undefined (если им не манипулировали), true или false
        if (this.get('ageInstalled') === false) {
            delete data.age;
        }

        // DIRECT-78449
        // domain - могут редактировать внутренние роли.
        // Если из под клиента отправить пустую строку, java - считает, пользователь без прав редактирует поле
        if (u.consts('rights').ajaxAdGroupsMultiSave && !u.consts('rights').canEditDomain) {
            data.domain = null;
        }

        // DIRECT-40019
        // если нет основной ссылки - то и отображаемого домена быть не должно
        data.href || delete data.domain;

        data.has_href = data.is_href_required || data.href ? 1 : 0;

        data.cid = this.get('cid');
        data.ad_type = this.get('ad_type');
        data.image_ad = this.get('image_ad').toJSON();
        data.creative = this.get('creative').toJSON();

        // графический баннер не может быть мобильным
        (data.ad_type === 'image_ad' || data.ad_type === 'cpc_video') && (data.banner_type = 'desktop');

        //DIRECT-45479: пробрасываем на второй шаг параметр openStat
        data.statusOpenStat = this.get('statusOpenStat');

        // для создания нового баннера нужны эти флаги
        data.hasCopyFromPrev = this.get('hasCopyFromPrev');
        data.isNewBanner = this.get('isNewBanner');

        data.video_resources = u._.get(data, 'video_resources.id', null) ? data.video_resources : {};
        data.disable_videomotion = this.get('disable_videomotion');

        data.turbolanding_href_params = this.get('turbolanding_href_params') || '';

        if (turbolanding) {
            data.turbolanding = turbolanding;
        }

        shouldClearTurbo = this.get('has_site') && (data.ad_type === 'text' ? !data.href && !data.has_vcard : !data.href);

        if (shouldClearTurbo) { // если нету ссылки или визитной карточки для ТГО без дополнений, то турбо-страницы сбрасываем
            delete data.turbolanding;

            if (data.sitelinks) {
                data.sitelinks.forEach(function(sitelink) {
                    delete sitelink.turbolanding;
                });
            }
        }

        return data;
    },

    /**
     * Фильтрует данные из toJSON, оставляя необходимые для копирования
     * Убирает служебные поля и поля статусов
     * @returns {Object}
     */
    toJSONForCopy: function() {
        var data = u._.pick(this.toJSON(), this.PARAMS_FOR_COPY[this.get('ad_type')]);

        return u._.extend(data);
    },

    /**
     * Возвращает данные, необходимые для отрисовки ошибок в хедере
     * @returns {Object}
     */
    toJSONForErrors: function() {
        var res = {};

        ['isNewBanner', 'newBannerIndex', 'bid', 'modelId'].forEach(function(name) {
            res[name] = this.get(name);
        }, this);

        return res;
    },

    /**
     * Возвращает данные визитки
     * @returns {Object}
     */
    getVCardData: function() {
        return this.get('vcard');
    },

    /**
     * Поля модели, которые могут копироваться в другой баннер
     */
    PARAMS_FOR_COPY: {
        text: [
            'has_href',
            'has_vcard',
            'is_vcard_open',
            'is_vcard_collapsed',
            'title',
            'title_extension',
            'body',
            'image_model',
            'sitelinks',
            'video_resources',
            'disable_videomotion',
            'href_model',
            'vcard',
            'callouts',
            'display_href',
            'lang',
            'ad_type',
            'turbolanding',
            'turbolanding_href_params',
            'banner_price'
        ],
        image_ad: [
            // порядок имеет значение
            'ad_type',
            'href_model',
            'image_ad',
            'creative'
        ],
        cpc_video: [
            // порядок имеет значение
            'ad_type',
            'href_model',
            'creative'
        ]
    },

    /**
     * Возвращает флаг используется ли в баннере уточнение с указанным ID
     * @param {Number|String} id - идентификатор уточнения
     * @returns {Boolean}
     */
    isCalloutInUse: function(id) {
        return this.get('callouts').some(function(callout) {
            return callout.additions_item_id == id;
        });
    },

    /**
     * Удаляет из баннера уточнение с указанным ID
     * @param {Number|String} id - идентификатор уточнения
     */
    deleteCalloutById: function(id) {
        this.set('callouts', this.get('callouts').filter(function(callout) {
            return callout.additions_item_id !== id;
        }));
    },

    hasTurboLink: function() {
        var hasTurbolanding = !!+this.get('turbolanding').get('id'),
            hasTurboSiteLink = this.get('sitelinks').hasTurboSitelink();

        return hasTurbolanding || hasTurboSiteLink;
    }
});
