BEM.MODEL.decl('m-bidable', {
    modelId: {
        type: 'string',
        internal: true
    },
    //id группы, к которой принадлежит фраза
    adgroup_id: {
        type: 'string',
        internal: true
    },
    //нужно для сортировки
    phrase: {
        type: 'string',
        validation: {
            maxlength: {
                value: CONSTS.CAMPAIGN_MINUS_WORDS_LIMIT,
                text: iget2('m-bidable', 'prevyshena-dopustimaya-dlina-klyuchevyh', 'Превышена допустимая длина ключевых фраз в {foo} символов', {
                    foo: CONSTS.CAMPAIGN_MINUS_WORDS_LIMIT
                })
            }
        }
    },
    //приостановка фразы
    is_suspended: { type: 'boolean', default: false },
    campDMName: { type: 'string', internal: true, default: 'm-campaign' },

    //фраза была удалена
    is_deleted: { type: 'boolean', default: false },
    autobroker: {
        type: 'number',
        preprocess: function(val) {
            if (val === undefined) return 0;

            return (+val);
        }
    },
    //трагический контент
    disabled_tragic: 'boolean',
    //данные по спецразмещению
    premium: 'array',
    //данные по позициям гарантии
    guarantee: 'array',
    //данные по ГО на поиске
    price_for_mcbanner: 'array',

    //объем трафика
    traffic_volume: {
        type: 'object'
    },

    // охват в сетях
    price_for_coverage: {
        type: 'object'
    },

    //данные от показометра
    larr: 'string',
    //данные от показометра
    probs: 'string',
    // БК не отвечает
    nobsdata: 'boolean',
    //минимальная цена на поиске
    min_price: 'string',
    //цена охвата на поиске - context_scope% от аудитории
    context_scope: 'string',
    //не пришла статистика от показометра
    no_pokazometer_stat: 'boolean',
    //цена (или цена на поиске при отключенном контексте)
    price: {
        type: 'rounded-number',
        validation: function() {
            var campaignModelName = this.get('campDMName'),
                priceLimits = u.bids.getLimits(
                    campaignModelName,
                    BEM.MODEL.getOne(campaignModelName).get('currency')
                );

            return {
                rules: {
                    required: { text: iget2('m-bidable', 'stavka-dolzhna-byt-chislom', 'Ставка должна быть числом') },
                    gte: {
                        value: priceLimits.maxPrice.value,
                        text: priceLimits.maxPrice.errorText
                    },
                    lte: {
                        value: priceLimits.minPrice.value,
                        text: priceLimits.minPrice.errorText
                    }
                },

                needToValidate: this.isEditablePriceField('price')
            };
        }
    },
    //цена на контекстных площадках
    price_context: {
        type: 'rounded-number',
        validation: function() {
            var campaignModelName = this.get('campDMName'),
                campModel = BEM.MODEL.getOne(campaignModelName),
                priceLimits = u.bids.getLimits(
                    campaignModelName,
                    BEM.MODEL.getOne(campaignModelName).get('currency'),
                    campModel.get('cid'),
                    this.get('adgroup_id')
                );

            return {
                rules: {
                    required: { text: iget2('m-bidable', 'stavka-dolzhna-byt-chislom', 'Ставка должна быть числом') },
                    gte: {
                        value: priceLimits.maxPrice.value,
                        text: priceLimits.maxPrice.errorText
                    },
                    lte: {
                        value: priceLimits.minPrice.value,
                        text: priceLimits.minPrice.errorText
                    }
                },
                needToValidate: this.isEditablePriceField('price_context')
            };
        }
    },
    // текущая цена клика на поиске
    broker: {
        type: 'rounded-number'
    },
    //цена на поиске
    search_price: 'number',
    //охват аудитории
    coverage: { type: 'number', precision: 0 },
    //охват аудитории только на контекстных площадках
    context_coverage: {
        type: 'number',
        precision: 0,
        formatOptions: { roundType: 'floor' }
    },
    //статистика по кликам
    clicks: 'number',
    //данные из показометра
    pokazometer_data: '',
    effective_ctr: 'number',
    ctr: 'number',
    // ctr на контекстных площадках
    ctx_ctr: 'number',
    //статистика по кликам на контекстных площадках
    ctx_clicks: { type: 'number', precision: 0 },
    //статистика по показам
    shows: { type: 'number', precision: 0 },
    //статистика по показам на контекстных площадках
    ctx_shows: { type: 'number', precision: 0 },
    // статистика по % выигрышей (для охватного продукта - cpm_banner)
    winrate: 'number',
    //тип фразы/условия ретаргетинга - активное/отклоненное/отключенное за низкий ctr
    //'active', 'context', 'low_ctr', 'declined'
    state: 'string',
    rank: 'string'
}, {
    /**
     * Определяет нужно ли редактировать поля price или price_context
     * в зависимости от стратегии
     * @param {String} name — название поля
     * @returns {Boolean}
     */
    isEditablePriceField: function(name) {
        var state = this.get('state'),
            campModel = BEM.MODEL.getOne(this.get('campDMName')),
            strategy = campModel.get('strategy'),
            strategyName = strategy && strategy.name || campModel.get('strategy_name'),
            searchStrategy = strategy && strategy.search && strategy.search.name || campModel.get('search_strategy'),
            placeStrategy = campModel.get('platform'),
            groupHasOnlyCpcVideoAndImageAds = this.getParentModel() &&
                u.imageAd.groupHasOnlyCpcVideoAndImageAds(this.getParentModel().get('group_banners_types')),
            isRelevanceMatch = this.name == 'm-relevance-match',
            isRetargeting = this.name === 'm-retargeting-bidable',
            isCpmBanner = u.campaign.isCpm(campModel.get('mediaType'));

        if (name === 'price') {
            var isSearchEditable = !~['low_ctr', 'declined', 'context'].indexOf(state) &&
                !campModel.get('is_autobudget'),
                isSearchRetargeting = isRetargeting && u.consts('isSearchRetargetingEnabled') && placeStrategy === 'search';

            return !isCpmBanner &&
                !isSearchRetargeting &&
                isSearchEditable &&
                //если в группе только графические баннеры то поиск доступен для редактирования только для общей (без отдельного размещения) стратегии
                (groupHasOnlyCpcVideoAndImageAds && (strategyName !== 'different_places') ||
                    //если в группе есть текстовые баннеры, а не только графические
                    !groupHasOnlyCpcVideoAndImageAds &&
                        //то поиск редактируем и на общих стратегиях, и на отдельном размещении если в нем не отключен поиск
                        (strategyName !== 'different_places' ||
                        (!!~['search', 'both'].indexOf(placeStrategy) || isRelevanceMatch) &&
                        (searchStrategy !== 'stop')));
        }

        if (name === 'price_context') {
            return !isRelevanceMatch && (!~['low_ctr', 'declined'].indexOf(state) && !campModel.get('is_autobudget') &&
                (state === 'context' || strategyName === 'different_places' &&
                    !!~['context', 'both'].indexOf(placeStrategy) || searchStrategy === 'stop'));
        }
    }
});
