describe('m-bidable', function() {
    var bidableData = {
            "phrase": "детский одежда",
            "price": 309.2,
            "price_context": 0.3,
            "state": "active",
            "adgroup_id": "261382980",
        },
        campData = {
            "platform": "search",
            "strategy": {
                "is_net_stop": "1",
                "is_autobudget": "",
                "search": { "name": "default" },
                "name": "",
                "net": { "name": "stop" },
                "is_search_stop": ""
            },
            "strategy_name": ""
        },
        groupData = {
            "group_banners_types": [
                {
                    "count": "6",
                    "banner_type": "text"
                }
            ],
            "adgroup_id": "261382980",
            "adgroup_type": "text"
        },
        bidableModel,
        adgroupModel,
        campModel;

    beforeEach(function() {
        campModel = BEM.MODEL.create({ name: 'm-campaign', id: 'm-campaign-id'}, campData);
        adgroupModel = BEM.MODEL.create({ name: 'm-group', id: 'm-adgroup-id'}, groupData);
        bidableModel = BEM.MODEL.create({ name: 'm-bidable', id: 'm-bidable-id', parentName: 'm-group', parentId: 'm-adgroup-id' }, bidableData);
    });

    afterEach(function() {
        bidableModel.destruct();
        adgroupModel.destruct();
        campModel.destruct();
    });

    describe('isEditablePriceField возвращает значения для поля price', function() {
        it('Для автобюджетной стратегии возвращает false', function() {
            campModel.set('is_autobudget', true);

            expect(bidableModel.isEditablePriceField('price')).to.be.false;
        });

        ['low_ctr', 'declined', 'context'].forEach(function(state) {
            it ('При state ' + state + ' возвращает false', function() {
                bidableModel.set('state', state);

                expect(bidableModel.isEditablePriceField('price')).to.be.false;
            })
        });

        ['active', 'new'].forEach(function(state) {
            describe('Для неавтобюджетной стратегии и state ' + state, function() {
                beforeEach(function() {
                    campModel.set('is_autobudget', false);
                    bidableModel.set('state', state);
                });
                describe('Если в группе только ГО', function() {
                    beforeEach(function() {
                        adgroupModel.set('group_banners_types', [{ banner_type: "image_ad", count: "6" }]);
                    });

                    [
                        'default',
                        'min_price',
                        'autobudget_avg_click',
                        'autobudget_avg_cpa',
                        'autobudget_avg_cpi',
                        'autobudget_roi',
                        'autobudget',
                        'autobudget_week_bundle',
                        'autobudget_optimization_cpc',
                        'autobudget_optimization_cpa'
                    ].forEach(function(strategy) {
                        it('Для нераздельного управления (стратегия: ' + strategy + ') возвращает true', function() {
                            campModel.set('strategy_name', strategy);

                            expect(bidableModel.isEditablePriceField('price')).to.be.true;
                        });
                    });

                    it('Для раздельного управления возвращает false', function() {
                        campModel.set('strategy_name', 'different_places');

                        expect(bidableModel.isEditablePriceField('price')).to.be.false;
                    });
                });
                describe('Если в группе не только ГО', function() {
                    beforeEach(function() {
                        adgroupModel.set('group_banners_types', [{ banner_type: "text", count: "6" }]);
                    });

                    [
                        'default',
                        'min_price',
                        'autobudget_avg_click',
                        'autobudget_avg_cpa',
                        'autobudget_avg_cpi',
                        'autobudget_roi',
                        'autobudget',
                        'autobudget_week_bundle',
                        'autobudget_optimization_cpc',
                        'autobudget_optimization_cpa'
                    ].forEach(function(strategy) {
                        it('Для нераздельного управления (стратегия: ' + strategy + ') возвращает true', function() {
                            campModel.set('strategy_name', strategy);

                            expect(bidableModel.isEditablePriceField('price')).to.be.true;
                        });
                    });

                    describe('Для раздельного управления', function() {
                        beforeEach(function() {
                            campModel.set('strategy_name', 'different_places');
                        });

                        it('Если отключен поиск, возвращает false', function() {
                            campModel.set('strategy', { search: { name: 'stop' } });

                            expect(bidableModel.isEditablePriceField('price')).to.be.false;
                        });

                        it('Если платформа сети, возвращает false', function() {
                            campModel.set('platform', 'net');

                            expect(bidableModel.isEditablePriceField('price')).to.be.false;
                        });

                        it('Если не отключен поиск и платформа на поиске, возвращает true', function() {
                            campModel.set('strategy', { search: { name: 'default' } });
                            campModel.set('platform', 'search');

                            expect(bidableModel.isEditablePriceField('price')).to.be.true;
                        });

                        it('Если не отключен поиск и платформа на поиске и в сети, возвращает true', function() {
                            campModel.set('strategy', { search: { name: 'default' } });
                            campModel.set('platform', 'both');

                            expect(bidableModel.isEditablePriceField('price')).to.be.true;
                        });
                    });
                });
            });
        });
    });

    describe('isEditablePriceField возвращает значения для поля price_context', function() {
        it('Для автобюджетной стратегии возвращает false', function() {
            campModel.set('is_autobudget', true);

            expect(bidableModel.isEditablePriceField('price_context')).to.be.false;
        });

        ['low_ctr', 'declined'].forEach(function(state) {
            it ('При state ' + state + ' возвращает false', function() {
                bidableModel.set('state', state);

                expect(bidableModel.isEditablePriceField('price_context')).to.be.false;
            })
        });

        describe('Для неавтобюджетной стратегии', function() {
            beforeEach(function() {
                campModel.set('is_autobudget', false);
            });

            it('Для state - context возвращает true', function() {
                bidableModel.set('state', 'context');

                expect(bidableModel.isEditablePriceField('price_context')).to.be.true;
            });

            ['active', 'new'].forEach(function(state) {
                describe('Для state - ' + state, function() {
                    beforeEach(function() {
                        bidableModel.set('state', state);
                    });

                    it('Для раздельного управления возвращает true', function() {
                        campModel.set('strategy_name', 'different_places');

                        expect(bidableModel.isEditablePriceField('price_context')).to.be.false;
                    });

                    [
                        'default',
                        'min_price',
                        'autobudget_avg_click',
                        'autobudget_avg_cpa',
                        'autobudget_avg_cpi',
                        'autobudget_roi',
                        'autobudget',
                        'autobudget_week_bundle',
                        'autobudget_optimization_cpc',
                        'autobudget_optimization_cpa'
                    ].forEach(function(strategy) {
                        describe('Для нераздельного управления (стратегия: ' + strategy + ')', function() {
                            beforeEach(function() {
                                campModel.set('strategy_name', strategy);
                            });

                            it('Если не отключен поиск, возвращает false', function() {
                                campModel.set('strategy', { search: { name: 'default' } });

                                expect(bidableModel.isEditablePriceField('price_context')).to.be.false;
                            });

                            it('Если платформа поиск, возвращает false', function() {
                                campModel.set('platform', 'search');

                                expect(bidableModel.isEditablePriceField('price_context')).to.be.false;
                            });

                            it('Если отключен поиск и платформа в сетях, возвращает true', function() {
                                campModel.set('strategy', { search: { name: 'stop' } });
                                campModel.set('platform', 'search');

                                expect(bidableModel.isEditablePriceField('price_context')).to.be.true;
                            });

                            it('Если отключен поиск и платформа на поиске и в сети, возвращает true', function() {
                                campModel.set('strategy', { search: { name: 'stop' } });
                                campModel.set('platform', 'both');

                                expect(bidableModel.isEditablePriceField('price_context')).to.be.true;
                            });
                        });
                    });
                });
            });
        });
    });
});
