BEM.MODEL.decl({ model: 'm-campaign', baseModel: 'dm-base-campaign' }, {
    vcard: {},
    with_ci: 'flag',

    //установлена общая визитка на кампанию
    common_vcard_set: 'boolean',

    // максимальная ставка при автобюджете
    autobudget_bid: 'string',
    // Отключена подстановка части текста в заголовок в баннера (поиск - десктоп)
    no_title_substitute: 'number',

    // Данные по целям Яндекс Метрики
    metrika: {
        type: 'model',
        modelName: 'dm-metrika'
    },

    // Таргетинг на устройства (данные о выбранных устройствах)
    device_targeting: 'string',

    //@deprecated
    hasPlatformSelect: 'boolean',
    //Дополнительные счетчики Метрики
    metrika_counters: 'string',
    //Разметка ссылок для Метрики - включить разметку ссылок
    status_click_track: 'boolean',
    //--Мониторинг сайта
    //останавливать объявления при неработающем сайте
    statusMetricaControl: 'flag',
    //Внешняя интернет-статистика
    statusOpenStat: 'flag',
    //Стоимость за 1000 кликов, используется на списке кампаний в баяне
    cost: 'number',

    maxKeywordLimit: 'number',

    //@heliarian - для баяна - ввод числа показов, которые нужно оплатить
    showsInput: {
        type: 'blank-number',
        precision: 0,
        internal: true,
        validation: {
            rules: {
                type: {
                    text: iget2('m-campaign', 'nepravilno-ukazano-chislo-pokazov', 'Неправильно указано число показов')
                },
                lte: {
                    value: 0,
                    text: iget2('m-campaign', 'nepravilno-ukazano-chislo-pokazov', 'Неправильно указано число показов')
                }
            },
            needToValidate: function() {
                return !!this.get('showsInput') || this.get('showsInput') === 0;
            }
        }
    },
    // Флаг говорит о том, что опция "Расширенный географический таргетинг" отключена
    no_extended_geotargeting: {
        type: 'enum',
        enum: [0, 1]
    },

    // раннее загруженные изображения для графических баннеров
    pictures: 'array',

    broad_match_flag: 'boolean',
    broad_match_rate: 'string',
    broad_match_limit: 'string',
    broad_match_goal_id: 'string',
    is_related_keywords_enabled: 'boolean',

    //---настройки на тематических площадках
    ContextLimit: 'string', //Расход удерживать в пределах
    ContextPriceCoef: 'string', //Максимальная цена клика от назначенной на поиске
    enable_cpc_hold: 'string', // удерживать цену клика на тематических площадках ниже цены клика на поиске,
    isCpaPayForConversionEnabled: 'boolean',

    // ключевые цели метрики (DIRECT-73912)
    meaningful_goals: 'array',

    counters_in_experiments: 'object',

    // pageId (идентификаторы страниц сайтов), на которых указывается рекламная кампания
    allowed_page_ids: {
        type: 'string',
        validation: {
            rules: {
                maxLength: {
                    value: u.consts('allowPageIdsLimit'),
                    text: u.pluralForms(
                        iget2(
                            'm-campaign',
                            'error-message-max-length',
                            'Превышена максимальная длина строки, {maxLength} {символ|символа|символов}.',
                            { maxLength: u.consts('allowPageIdsLimit') }
                        ),
                        u.consts('allowPageIdsLimit')
                    ),
                    needToValidate: function(val) {
                        return !!val;
                    }
                }
            }
        }
    },

    // Доступность фичи cpc_video_banner
    isFeatureCpcBannerVideoEnabled: 'boolean',

    dialog_id: 'string',
    dialog_name: 'string',
    brandSafetyCategories: 'array'
});
