BEM.MODEL.decl('m-client-wallet', {
    currency: 'string',
    clientNds: 'number',
    customMinPay: 'number',
    isOfferAccepted: 'boolean',
    isOfferHideFeatureEnabled: 'boolean',
    //сумма к оплате с НДС
    sum_with_nds: {
        type: 'number',
        precision: 2,
        formatOptions: {
            precision: 2,
            roundType: 'floor'
        },
        validation: {
            rules: {
                paymentMethodCardLimit: {
                    text: function() {
                        var currency = this.get('currency'),
                            maxPaymentSum = u.currencies.getConst(
                                currency,
                                this.get('payment_method') === 'cash' ? 'PAY_WITH_CASH_LIMIT' : 'RECOMMENDATION_SUM_WARN'
                            ),
                            maxPaymentSumWithNds = Math.round(maxPaymentSum + maxPaymentSum * Number(this.get('clientNds')) / 100);

                        return this.get('payment_method') === 'cash' ?
                            iget2('b-client-wallet', 'pay-with-cash-limit', 'Максимальная сумма пополнения при оплате наличными составляет {sum} {currency}', {
                                sum: u.numberFormatter.format(maxPaymentSumWithNds, { precision: 2 }),
                                currency: u.currencies.get(currency).currency_sign
                            }) :
                            iget2('b-client-wallet', 'pay-with-card-limit', 'Максимальная сумма пополнения при оплате картой составляет {sum} {currency}', {
                                sum: u.numberFormatter.format(maxPaymentSumWithNds, { precision: 2 }),
                                currency: u.currencies.get(currency).currency_sign
                            });
                    },
                    needToValidate: function() {
                        return u._.contains(['card', 'card-legal', 'cash'], this.get('payment_method')) && !!this.get('nds');
                    },
                    validate: function() {
                        var currency = this.get('currency'),
                            maxPaymentSum = u.currencies.getConst(
                                currency,
                                this.get('payment_method') === 'cash' ? 'PAY_WITH_CASH_LIMIT' : 'RECOMMENDATION_SUM_WARN'
                            ),
                            maxPaymentSumWithNds = Math.round(maxPaymentSum + maxPaymentSum * Number(this.get('clientNds')) / 100);

                        return this.get('sum_with_nds') <= maxPaymentSumWithNds;
                    }
                }
            }
        }
    },
    //сумма к оплате в рублях
    sum_money_local: {
        type: 'number',
        formatOptions: {
            precision: 2,
            roundType: 'floor'
        }
    },
    nds: {
        type: 'number',
        precision: 2
    },
    //сумма на едином счете
    sum: {
        type: 'number',
        formatOptions: {
            precision: 2,
            roundType: 'floor'
        },
        validation: {
            rules: {
                required: { text: iget2('m-client-wallet', 'nepravilno-ukazana-summa-k', 'Неправильно указана сумма к оплате.') },
                type: { text: iget2('m-client-wallet', 'nepravilno-ukazana-summa-k', 'Неправильно указана сумма к оплате.') },
                lte: function() {
                    var currencyName = this.get('currency'),
                        minPay = this.get('customMinPay');

                    return {
                        value: minPay,
                        text: iget2('m-client-wallet', 'summa-k-oplate-dolzhna', 'Сумма к оплате должна быть не менее {foo}', {
                            foo: u.currencies.formatSum(currencyName, minPay) || u.currencies.formatConst(currencyName, 'MIN_PAY')
                        })
                    };
                },
                paymentMethodCardLimit: {
                    text: function() {
                        var currency = this.get('currency'),
                            sum = u.currencies.getConst(currency, 'RECOMMENDATION_SUM_WARN');

                        return iget2('b-client-wallet', 'pay-with-card-limit', 'Максимальная сумма пополнения при оплате картой составляет {sum} {currency}', {
                            sum: u.numberFormatter.format(sum, { precision: 2 }),
                            currency: u.currencies.get(currency).currency_sign
                        });
                    },
                    needToValidate: function() {
                        return u._.contains(['card', 'card-legal'], this.get('payment_method')) && !this.get('nds');
                    },
                    validate: function() {
                        return this.get('sum') <= u.currencies.getConst(this.get('currency'), 'RECOMMENDATION_SUM_WARN');
                    }
                }
            }
        }
    },
    payer_type: {
        type: 'enum',
        enum: [
            'phys',
            'legal'
        ]
    },
    payment_method: {
        type: 'enum',
        enum: [
            'card',
            'card-legal',
            'wire',
            'cash',
            'overdraft',
            'promocode',
            'other',
            'none'
        ],
        default: 'none'
    },
    credit_card_id: {
        type: 'string'
    },
    autopayment_enabled: {
        type: 'boolean'
    },
    autopaymentAgreedTo: {
        type: 'boolean',
        dependsFrom: ['payment_method', 'autopayment_enabled'],
        calculate: function() {
            if (this.get('payment_method') === 'card' && this.get('autopayment_enabled')) {
                return true;
            }
            if (this.get('payment_method') === 'card-legal' && this.get('autopayment_enabled') && this.get('hasSingleLegalPayer')) {
                return true;
            }
            return false;
        }
    },
    offer_agreed: {
        type: 'boolean',
        validation: {
            rules: {
                required: {
                    text: function() {
                        if (this.get('autopaymentAgreedTo')) {
                            return iget2('m-client-wallet', 'need-to-agree-to-autopayment-offer', 'Чтобы подключить услугу "Автоплатёж", подтвердите своё согласие с Офертой на оказание услуг');
                        } else if (this.get('switchOffLimitAgreedTo')) {
                            return iget2('m-client-wallet', 'need-to-agree-to-switch-off-limit-offer2', 'Чтобы подключить услугу "Порог отключения показов", подтвердите своё согласие с Офертой на оказание услуг');
                        }
                    },
                    needToValidate: function() {
                        return (this.get('isOfferHideFeatureEnabled') && this.get('paymentMethod') === 'card') || this.get('autopaymentAgreedTo') || this.get('switchOffLimitAgreedTo');
                    },
                    validate: function() {
                        return this.get('offer_agreed');
                    }
                }
            }
        }
    },
    remaining_sum: {
        type: 'number',
        formatOptions: {
            precision: 2,
            roundType: 'floor'
        }
    },
    promocode: {
        type: 'string'
    },
    autopayment_sum: {
        type: 'number',
        formatOptions: {
            precision: 2,
            roundType: 'floor'
        },
        validation: {
            rules: {
                mustBePositive: {
                    text: function() {
                        var currency = this.get('currency');

                        return iget2('b-client-wallet', 'minimum-autopayment-sum', 'Минимально допустимая сумма автоплатежа составляет {sum} {currency}', {
                            sum: u.currencies.getConst(currency, 'MIN_AUTOPAY'),
                            currency: u.currencies.get(currency).currency_sign
                        });
                    },
                    needToValidate: function() {
                        return this.get('autopaymentAgreedTo') || this.get('switchOffLimitAgreedTo');
                    },
                    validate: function() {
                        return this.get('autopayment_sum') >= u.currencies.getConst(this.get('currency'), 'MIN_AUTOPAY');
                    }
                },
                paymentMethodCardLimit: {
                    text: function() {
                        var currency = this.get('currency'),
                            sum = u.currencies.getConst(currency, 'RECOMMENDATION_SUM_WARN');

                        return iget2('b-client-wallet', 'pay-with-card-limit', 'Максимальная сумма пополнения при оплате картой составляет {sum} {currency}', {
                            sum: u.numberFormatter.format(sum, { precision: 2 }),
                            currency: u.currencies.get(currency).currency_sign
                        });
                    },
                    needToValidate: function() {
                        return this.get('autopaymentAgreedTo') || this.get('switchOffLimitAgreedTo');
                    },
                    validate: function() {
                        return this.get('autopayment_sum') <= u.currencies.getConst(this.get('currency'), 'RECOMMENDATION_SUM_WARN');
                    }
                }
            }
        }
    },
    switch_off_limit_enabled: {
        type: 'boolean'
    },
    switchOffLimitAgreedTo: {
        type: 'boolean',
        dependsFrom: ['payment_method', 'switch_off_limit_enabled'],
        calculate: function() {
            return u._.include(['card', 'card-legal', 'wire'], this.get('payment_method')) && this.get('switch_off_limit_enabled');
        }
    },
    switch_off_limit: {
        type: 'number',
        formatOptions: {
            precision: 2,
            roundType: 'floor'
        },
        preprocess: function(val) {
            var lowerLimit = this.model.get('switch_off_lower_limit'),
                upperLimit = this.model.get('switch_off_upper_limit');

            if (val < lowerLimit) {
                return lowerLimit;
            } else if (val > upperLimit) {
                return upperLimit;
            }
            return val;
        }
    },
    switch_off_lower_limit: {
        type: 'number'
    },
    switch_off_upper_limit: {
        type: 'number'
    },
    payer_id: {
        type: 'string',
    },
    canUsePromocodes: {
        type: 'boolean'
    },
    hasSingleLegalPayer: {
        type: 'boolean'
    }
});
