BEM.MODEL.decl('m-day-budget', {
    set: { type: 'boolean', default: false },

    show_mode: { type: 'string', default: 'default' },

    currency: 'string',

    daily_change_count: { type: 'number', default: 0 },

    active: { type: 'boolean', default: false },

    // минимальное значение суммы дневного бюджета для валидации
    minValue: { type: 'number' },

    sum: {
        type: 'blank-number',
        validation: function() {
            var currencyName = this.get('currency') || 'YND_FIXED',
                currency = u.currencies.get(currencyName),
                minValue = this.get('minValue') != undefined ? this.get('minValue') : currency.MIN_DAY_BUDGET;

            return {
                rules: {
                    required: {
                        text: iget2('m-day-budget', 'ne-ukazana-summa-dnevnogo', 'Не указана сумма дневного бюджета'),
                        validate: function(val) { return !!val }
                    },
                    type: {
                        text: iget2('m-day-budget', 'neverno-ukazana-summa-dnevnogo', 'Неверно указана сумма дневного бюджета'),
                        needToValidate: function() { return !!this.get('sum') }
                    },
                    lte: {
                        value: minValue,
                        text: iget2('m-day-budget', 'summa-dnevnogo-byudzheta-ne', 'Сумма дневного бюджета не может быть меньше {foo}', {
                            foo: u.currencies.formatSum(currencyName, minValue)
                        }),
                        needToValidate: function() { return !!this.get('sum') }
                    },
                    gte: {
                        value: currency.MAX_DAILY_BUDGET_AMOUNT,
                        text: iget2('m-day-budget', 'summa-dnevnogo-byudzheta-ne-101', 'Сумма дневного бюджета не может быть больше {foo}', {
                            foo: u.currencies.formatConst(currencyName, 'MAX_DAILY_BUDGET_AMOUNT')
                        }),
                        needToValidate: function() { return !!this.get('sum') }
                    }
                },

                needToValidate: function() {
                    //active - чекбокс в попапе стратегий, set - радиобаттон в попапе дневного бюджета на странице списка кампаний
                    return !!this.get('active') || !!this.get('set');
                }
            };
        }
    }
});
