BEM.MODEL.decl({ model: 'm-group', baseModel: 'dm-base-group' }, {
    edit_banners_quantity: 'number',

    banners: {
        type: 'models-list',
        modelName: 'm-banner'
    },
    // Идентификаторы баннеров в группе
    bannersIds: {
        type: 'array',
        internal: true,
        dependsFrom: 'banners',
        calculate: function() {
            return this.getBanners().map(function(banner) {
                return '' + banner.id;
            });
        }
    },
    //метки на группу объявлений
    tags: { type: 'models-list', modelName: 'm-group-tag' },
    page: { type: 'number', default: 1 },
    shownBids: { type: 'array', default: [] }, // список id показываемых баннеров
    phrasesIds: { type: 'array', default: [], internal: true }, // список id фраз в баннере
    retargetingsIds: { type: 'array', default: [], internal: true }, // список ret_id условий ретаргетинга в баннере
    //показывать в превью свежие добавленные баннеры
    showNewBanners: 'boolean',
    //у баннеров в данной  группе есть визитка
    withVCard: 'boolean',
    //нужно для корректной обработки ошибок
    phrases: 'string',
    //автотаргетинг
    has_relevance_match: {
        type: 'boolean',
        default: false
    },

    // архивная группа
    archive: {
        type: 'string',
        default: 'No'
    },

    // тип кампании (необходимо с появлением ГО на поиске)
    new_phrases: {
        type: 'array',
        internal: true,
        validation: {
            rules: {
                required: {
                    needToValidate: function() {
                        var retargetings = this.get('retargetingsIds'),
                            phrases = this.get('phrasesIds'),
                            relevanceMatchModel = this.getRelevanceMatchModel();

                        return (!retargetings || !retargetings.length) &&
                            (!relevanceMatchModel || relevanceMatchModel.get('bid_id') == '0') &&
                            (!this.get('has_relevance_match')) &&
                            (!phrases || !phrases.length ||
                            !phrases.filter(function(id) {
                                return !u.isEmpty(BEM.MODEL.getOrCreate({
                                    name: 'm-phrase-text',
                                    id: id,
                                    parentModel: this
                                }).get('phrase'))
                            }, this).length)
                    },
                    value: true,
                    text: iget2('m-group', 'ne-ukazany-klyuchevye-frazy', 'Не указаны ключевые фразы')
                },
                hasActive: {
                    text: function() {
                        return iget2(
                            'm-group',
                            'dlya-gruppy-neobhodimo-zadat',
                            'Для группы необходимо задать ключевые фразы или условия подбора аудитории или включить автотаргетинг'
                        );
                    },

                    validate: function() {
                        var count = 0,
                            state;

                        if (this.get('new_phrases').length > 0) return true;

                        this.getRetargetingsModels().map(function(model) {
                            if (!model.get('is_suspended') && !model.get('is_deleted')) {
                                count++
                            }
                        }, this);

                        this.getPhrasesModels().map(function(model) {
                            state = model.get('state');

                            if (state !== 'low_ctr' && state !== 'declined' && !model.get('is_suspended') &&
                                !model.get('is_deleted')) {

                                count++
                            }
                        }, this);

                        this.get('has_relevance_match') && count++;

                        return !!count;
                    }
                },
                phraseCount: {
                    text: function() {
                        var limit = this.getKeywordLimit();
                        return u.pluralForms(iget2(
                            'm-group',
                            'gruppa-dolzhna-soderzhat-ne',
                            'Группа должна содержать не более {foo} {ключевой фразы|ключевых фраз|ключевых фраз}',
                            {
                                foo: limit
                            }
                        ), limit);
                    },
                    validate: function() {
                        return this.getPhrasesLeft() >= 0;
                    }
                }
            }
        }
    },
    // дневной бюджет
    day_budget: 'string',
    // флаг автобюджета
    autobudget: 'string',
    // статус группы
    status: 'string',
    // статус модерации: группа активна
    statusActive: 'string',
    // флаг, что группа не остановлена
    statusShow: 'string',
    // баннер можно редактировать
    isBannersEditable: 'boolean',
    // показывать возрастные метки
    showAgeLabels: 'boolean',
    //группа находится в архивной кампании
    is_camp_archived: 'number',
    //у фраз в группе могут редактироваться ставки
    isBidable: { type: 'boolean', internal: true },
    canViewImageId: { type: 'boolean', internal: true },
    //находимся на странице редактирования одной группы
    isSingleGroup: { type: 'boolean', internal: true },
    //идет копирование группы
    isCopyGroup: { type: 'boolean', internal: true },
    // индекс новой группы
    newGroupIndex: { type: 'number' },
    // группа новая
    isNewGroup: { type: 'boolean' },
    //нужно для динамических групп, домен и ссылка в баннерах выставляются из данных группы
    domain: 'string',
    // флаг об остановке мониторинга сайта
    statusMetricaStop: 'string'
}, {
    getActivePhrasesCount: function() {},
    getLowCtrPhrasesCount: function() {},
    getDeclinedPhrasesCount: function() {},

    /**
     * Возвращает данные, необходимые для отрисовки ошибок в хедере
     * @returns {Object}
     */
    toJSONForErrors: function() {
        var res = {};

        ['isCopyGroup', 'newGroupIndex', 'isNewGroup', 'isSingleGroup', 'adgroup_id', 'modelId']
            .forEach(function(name) {
                res[name] = this.get(name);
            }, this);

        return res;
    },

    /**
     * Возврщает массив всех фраз
     * @returns {Array}
     */
    getAllPhrases: function() {
        return [].concat(this.get('new_phrases'), this.getPhrases());
    },

    /**
     * Возвращает количество старых фраз
     * @returns {Number}
     */
    getPhrasesLength: function() {
        return this.getPhrases().join(',').length;
    },

    /**
     * Добавление баннера
     * @param {Object} defaults - дефолтные данные (для пустого баннера)
     * @returns {BEM.MODEL}
     */
    addBanner: function(defaults) {
            // отфильтровываем только новые баннеры, чтобы сделать для них свою нумерацию
        var newBanners = this.getBannersWhere({ isNewBanner: true }),
            // для нового баннера берём номер предыдущего(последнего) нового баннера в списке,
            // чтобы не было проблем после удаления одного из ранее созданных
            newBannerIndex = newBanners.length ?
                +newBanners[newBanners.length - 1].get('newBannerIndex') + 1 :
                1,
            newBannerId = 'new' + newBannerIndex, // для клиентов показываем отсчёт новых баннеров с 1
            //если есть общая визитка на кампанию
            commonVCard = this.getCampaignModel().get('common_vcard_set') ?
                BEM.MODEL.getOrCreate({ name: 'm-vcard', id: 'common' }).toJSON() :
                {},
            modelData = u._.extend({}, defaults, {
                bid: 0,
                newBannerIndex: newBannerIndex,
                modelId: newBannerId,
                hasCopyFromPrev: true,
                vcard: commonVCard,
                loadVCardFromClient: true
            });

        return this.addBannerToList(modelData);
    },

    /**
     * Возвращает массив с данными по фразам, содержащимся в данной группе
     * @returns {Array}
     */
    getPhrasesData: function() {
        var _this = this,
            phrases = this.get('phrasesIds').reduce(function(goodPhrases, id) {
                var model = BEM.MODEL.getOrCreate({
                    name: _this.get('isBidable') ? 'm-phrase-bidable' : 'm-phrase-text',
                    id: id,
                    parentModel: _this
                });

                // DIRECT-40060
                // исключаем пустые фразы
                model.get('phrase') && goodPhrases.push(model.toJSON());

                return goodPhrases;
            }, []),
            newPhrases = this.get('new_phrases');

        if (newPhrases.length) {
            phrases = phrases.concat(newPhrases.map(function(phrase) {
                return {
                    phrase: phrase,
                    id: 0
                };
            }));
        }

        return phrases;
    },

    /**
     * Возвращает true, если кроме переданной фразы других активных нет
     * @param {BEM.MODEL} phraseModel - модель фразы
     * @returns {Boolean}
     */
    isLastActive: function(phraseModel) {
        var state = phraseModel.get('state');

        if (this.get('new_phrases').length > 0) return false;

        if (phraseModel.get('is_suspended') ||
            state != 'active' && state != 'new' && state != 'context') return false;

        var count = 0,
            modelId = phraseModel.get('modelId'),
            relevanceMatchModel = this.getRelevanceMatchModel(),
            relevanceMatchOn = relevanceMatchModel.get('bid_id') != '0' || this.get('has_relevance_match');

        this.getRetargetingsModels().map(function(model) {
            if (u.consts('isSearchRetargetingEnabled') && model.get('state') === 'search') {
                return;
            }

            if (model.get('modelId') !== modelId && !model.get('is_suspended') && !model.get('is_deleted')) {
                count++
            }
        }, this);

        this.getPhrasesModels().map(function(model) {
            state = model.get('state');

            if (model.get('modelId') !== modelId && state !== 'low_ctr' &&
                state !== 'declined' && !model.get('is_suspended') && !model.get('is_deleted')) {
                count++
            }
        }, this);

        modelId !== relevanceMatchModel.get('modelId') && relevanceMatchOn &&
            !relevanceMatchModel.get('is_suspended') && !relevanceMatchModel.get('is_deleted') &&
            count++;

        return count < 1;
    },

    /**
    * Возвращает количество ключевых фраз, которое еще можно добавить
    * @returns {Number}
    */
    getPhrasesLeft: function() {
        return this.getKeywordLimit() - this.getAllPhrases().length;
    },

    /**
     * Возвращает массив с данными по условиям ретаргетинга, содержащимся в данной группе
     * @returns {Array}
     */
    getRetargetingsData: function() {
        var modelData;

        return this.get('retargetingsIds').map(function(ret) {

            if (this.get('isBidable')) {
                modelData = BEM.MODEL.getOrCreate({
                    name: 'm-retargeting-bidable',
                    id: ret.ret_cond_id,
                    parentModel: this
                }).toJSON();

                modelData.ret_id = ret.ret_id;

                return modelData;
            } else {
                modelData = BEM.MODEL.getOrCreate({ name: 'm-retargeting-condition', id: ret.ret_cond_id }).toJSON();
                modelData.ret_id = ret.ret_id;

                return modelData;
            }
        }, this);
    },

    /**
     * Возвращает модель корректировок ставок
     * @returns {BEM.MODEL}
     */
    getMultipliersData: function() {
        return BEM.MODEL.getOrCreate({ name: 'm-adjustment-rates', id: this.get('modelId') }).provideData();
    },

    /**
     * Возвращает модель региона для данной группы
     * @returns {BEM.MODEL}
     */
    getGeoModel: function() {
        return BEM.MODEL.getOrCreate({ name: 'm-geo-regions', id: this.get('modelId'), parentModel: this });
    },

    /**
     * Возвращает модель бесфразного таргетинга (1 на группу)
     * @returns {*}
     */
    getRelevanceMatchModel: function() {
        return BEM.MODEL.getOrCreate({ name: 'm-relevance-match', id: this.get('modelId'), parentModel: this });
    },

    /**
     * Возвращает данные в формате, пригодном для сохранения на сервере
     * @returns {Object}
     */
    provideData: function() {
        var data = this.toJSON(),
            geoModel = this.getGeoModel(),
            randPhrase = this.getRandomActivePhraseModel();

        data.banners = this.getBanners()
            .filter(function(bannerModel) { return bannerModel.get('archive') !== 'Yes'; })
            .map(function(bannerModel) { return bannerModel.provideData(); });

        data.tags = {};

        this.get('tags').forEach(function(model) {data.tags[model.get('id')] = 1;});

        data.geo = geoModel.get('geo');

        // При добавлении нового объявления на странице редактирования, результат метода provideData передается в
        // bemhtml блока b-edit-banner, а после в блок превью баннера.
        // Добавил сюда phrases для подстановки фразы на место шаблона в новом превью и подписки на изменение.
        randPhrase && (data.phrases = [{
            modelName: randPhrase.name,
            modelId: randPhrase.get('modelId'),
            key_words: randPhrase.get('key_words'),
            param1: randPhrase.get('param1'),
            param2: randPhrase.get('param2')
        }]);

        // для получения модели кампании на 2-ом шаге редактирования
        data.cid = this.get('cid');

        // cyn@TODO: DIRECT-45870: унести на серверсайд
        data.adgroup_type = 'base';

        return data;
    },

    /**
     * Возвращает массив фраз, содержащихся в данной группе
     * @returns {Array}
     */
    getPhrases: function() {
        return this.getPhrasesModels().map(function(model) {
            return model.get('phrase');
        }, this);
    },

    /**
     * Возвращает массив с моделями фраз, содержащихся в данной группе
     * @returns {Array}
     */
    getPhrasesModels: function() {
        return this.get('phrasesIds').map(function(id) {
            return BEM.MODEL.getOrCreate({
                name: this.get('isBidable') ? 'm-phrase-bidable' : 'm-phrase-text',
                id: id,
                parentModel: this
            });
        }, this);
    },

    /**
     * Возвращает массив с моделями условий ретаргетинга, содержащихся в данной группе
     * @returns {Array}
     */
    getRetargetingsModels: function() {
        return this.get('retargetingsIds').map(function(id) {
            return BEM.MODEL.getOrCreate({ name: 'm-retargeting-bidable', id: id.ret_cond_id, parentModel: this });
        }, this);
    },

    /**
     * Возвращает массив (серверное требование) с данными по бесфразному таргетингу
     * @returns {Array}
     */
    getRelevanceMatchData: function() {
        var model = this.getRelevanceMatchModel(),
            json = model.toJSON(),
            data = u._.pick(json, ['bid_id', 'is_suspended', 'search_stop', 'net_stop']);

        data.price = model.get('price', 'formatted');
        data.price_context = model.get('price_context', 'formatted');

        return [data];
    },

    /**
     * Возвращает true если хотя бы одна фраза из содержащихся в группе была изменена
     * @returns {Boolean}
     */
    isPhrasesChanged: function() {
        return this.getPhrasesModels().some(function(model) {
            return model.isChanged('phrase');
        }, this);
    },

    /**
     * Преобразовывает серверные данные по баннеру в модельные
     * @param {Object} data
     * @returns {Object}
     */
    bannerDataToModelData: function(data) {
        return u['m-group'].transformBannerData({
            banner: data,
            group: this.provideData()
        });
    },

    /**
     * Преобразовывает серверные данные по группе в модельные (включая баннеры)
     * @param {Object} data
     * @returns {Object}
     */
    dataToModelData: function(data) {
        return u['m-group'].transformData({
            group: data
        });
    },

    /**
     * Возвращает лимит ключевых слов на группу, установленный для пользователя
     * @returns {*}
     */
    getKeywordLimit: function() {
        return this.getCampaignModel().get('maxKeywordLimit');
    },

    /**
     * Возвращает инстанс родительской модели кампании.
     *
     * @returns {BEM.MODEL}
     */
    getCampaignModel: function() {
        return this._campaignModel || (this._campaignModel = this.get('cid') ?
            BEM.MODEL.getOrCreate({ name: 'm-campaign', id: this.get('cid') }) :
            BEM.MODEL.getOne('m-campaign'));
    },

    /**
     * Возвращает массив баннеров в которых используется уточнение с указанным ID
     * @param {Number|String} id - идентификатор уточнения
     * @returns {Array}
     */
    getBannersWithCalloutId: function(id) {
        return this.get('banners').filter(function(bannerModel) {
            return bannerModel.isCalloutInUse(id);
        })
    }
});
