u.register({

    'm-group': {

        /**
         * Преобразовывает серверные данные группы в модельные
         * @param {Object} options
         * @param {Object} options.group
         * @param {Array} options.campaignTags
         * @param {Boolean} options.loadVCardFromClient
         * @returns {*}
         */
        transformData: function(options) {
            var group = options.group,
                campaignTags = options.campaignTags,
                loadVCardFromClient = options.loadVCardFromClient;

            // cyn@TODO: DIRECT-45870: унести на серверсайд
            group.adgroup_type === 'base' && (group.adgroup_type = 'text');

            var data = [
                'archive',
                'modelId',
                'isBidable',
                'adgroup_id',
                'banners_quantity',
                'banners_arch_quantity',
                'edit_banners_quantity',
                'has_general_limit_price',
                'is_camp_archived',
                'cid',
                'retargetings',
                'has_relevance_match',
                'relevance_match',
                'new_phrases',
                'page',
                'withVCard',
                'bannersCount',
                'minus_words',
                'group_banners_types',
                'shownBids',
                'group_name',
                'isBannersEditable',
                'showNewBanners',
                'statusBsSynced',
                'statusModerate',
                'statusPostModerate',
                'showAgeLabels',
                'newGroupIndex',
                'isNewGroup',
                'isCopyGroup',
                'isSingleGroup',
                'adgroup_type',
                //нужно для динамических групп, домен и ссылка в баннерах выставляются из домена группы
                'domain',
                'statusMetricaStop'
            ].reduce(function(data, name) {
                data[name] = group[name];

                return data;
            }, {});

            if (!data.group_name) data.group_name = iget2('m-group', 'novaya-gruppa-obyavleniy', 'Новая группа объявлений');

            if (group.tags) {
                data.tags = u._.isArray(group.tags) ?
                    group.tags :
                    //по пришедшим id тегов строим полный массив данных
                    Object.keys(group.tags).map(function(id) {
                        var cTag = (campaignTags || []).filter(function(tag) {
                            return tag.id === id;
                        }).pop();

                        return {
                            id: id,
                            value: cTag && cTag.value
                        };
                    }, this);
            }

            data.banners = u._.isArray(group.banners) ?
                group.banners.map(function(banner) {
                    return u['m-group'].transformBannerData({
                        banner: banner,
                        group: group,
                        loadVCardFromClient: loadVCardFromClient
                    });
                }) :
                [
                    u['m-group'].transformBannerData({
                        banner: group,
                        group: group,
                        loadVCardFromClient: loadVCardFromClient
                    })
                ];

            data.phrasesIds = group.phrases ?
                group.phrases.map(function(phrase) {
                    return phrase.modelId;
                }, this) :
                [];

            data.retargetingsIds = group.retargetings ?
                group.retargetings
                    .filter(function(retargeting) {
                        return retargeting.conditions_type === 'metrika_goals';
                    })
                    .map(function(retargeting) {
                        return {
                            ret_id: retargeting.ret_id,
                            ret_cond_id: retargeting.ret_cond_id
                        };
                    }, this) :
                [];

            data.has_relevance_match = group.has_relevance_match ||
                group.relevance_match && group.relevance_match.length > 0;

            return data;
        },

        /**
         * Преобразовывает серверные данные баннера в модельные
         * @param {Object} options
         * @param {Object} options.banner
         * @param {Object} options.group
         * @param {Boolean} options.loadVCardFromClient
         * @returns {*}
         */
        transformBannerData: function(options) {
            // DIRECT-39276, DIRECT-49050: statusModerate - поле группы, но оно нужно для блока b-banner-status,
            // подобная логике есть в предобработке данных для баннеров/групп i-banners-group-data.bemtree.xjst
            options.banner.groupStatusModerate = options.group.statusModerate;

            // DIRECT-61150 если с сервера не приходит протокол, пытаемся взять из href
            options.banner.url_protocol || (options.banner.url_protocol = u.getUrlProtocol(options.banner.href));

            return u.bannerModelData({
                banner: u.bannerData({
                    banner: options.banner
                }),
                group: options.group,
                loadVCardFromClient: options.loadVCardFromClient
            });
        }

    }

});
