(function() {

    /**
     * Возвращает параметры поля модели для списка моделей
     * @param {String} modelName
     * @returns {{type: String, modelName: String}}
     */
    function listField(modelName) {
        return { type: 'models-list', modelName: modelName };
    }

    BEM.MODEL.decl('m-infoblock-state', {
        // список элементов-событий инфоблока с новостями
        news: listField('m-infoblock-news'),
        // количество не всех элементов-событий инфоблока (сумма по новостям, тизерам и т.д.)
        itemsCount: {
            type: 'number',
            dependsFrom: ['news'],
            calculate: function() {
                var news = this.get('news');

                return news ? news.length() : 0;
            }
        },
        // флаг, что есть хотя бы 1 новое уведомление
        hasNewEvents: {
            type: 'boolean',
            dependsFrom: ['news'],
            calculate: function() {
                var news = this.get('news'),
                    result = false;

                return (news || []).reduce(function(result, event) {
                    return result || event.get('new');
                }, result);
            }
        }
    }, {

        /**
         * Возвращает название модели у поля
         * @param {String} field
         * @returns {String|Undefined}
         */
        getFieldModelName: function(field) {
            return this.fields[field].params.modelName;
        }

    });
})();
