block('m-interest-bidable').def()(function() {
    var interest = this.ctx.interest,
        group = this.ctx.group,
        data = [
            'target_category_id', 'ret_id', 'interest_name', 'interest_name_escape',
            'type', 'category_path', 'category_path_escape', 'modelId'].reduce(function(data, name) {
                data[name] = interest[name];

                return data;
            }, {});

    data.modelId = data.modelId || (data.ret_id + '-' + data.target_category_id);

    data.campaignId = this.data.campaign.cid || '0';
    data.adgroup_id = group.adgroup_id || '0';

    data.campDMName = u.campaign.getCampaignModelName(this.data.campaign.mediaType);

    // нужно для сортировки
    data.phrase = data.interest_name;

    return u._.extend(
        data,
        applyCtx({
            block: 'm-bidable',
            bidable: interest,
            group: group,
            campaign: this.data.campaign
        }));
});
