BEM.MODEL.decl({ name: 'm-interest-bidable', baseModel: 'm-bidable' }, {
    category_path: 'string',
    category_path_escape: 'string',
    interest_name: 'string',
    interest_name_escape: {
        type: 'string',

        calculate: function() {
            var tagsToReplace = {
                '&': '&amp;',
                '<': '&lt;',
                '>': '&gt;'
            };

            return u.hellipCut(this.get('interest_name').replace(/[&<>]/g, function(tag) {
                return tagsToReplace[tag] || tag;
            }), 50);
        },
        dependsFrom: 'interest_name'
    },
    target_category_id: 'string',
    ret_id: 'string'
}, {

});
