BEM.MODEL.decl('m-ip-list', {
    items: { type: 'models-list', modelName: 'm-ip-item' },
    apiAllowedIps: 'string'
}, {
    /**
     * Обновляет сводное поле по всем ip адресам, которое и отправляется на сервер.
     */
    updateAllowedIps: function() {
        this.set(
            'apiAllowedIps',
            this.get('items')
                .filter(function(item) {
                    return item.get('ip') !== '' || item.get('mask') !== '';
                }).map(function(item) {
                    var mask = item.get('mask');

                    return item.get('ip') + (mask ? '/' + mask : '');
                }).join(','));
    }
});
