BEM.MODEL.decl('m-modify-user-general-settings',{
    city: {
        type: 'string',
        validation: {
            //rules: { required: true }, DIRECT-52847
            needToValidate: function() { return this.get('regionEditPermission') }
        }
    },
    geo_id: {
        type: 'string',
        validation: {
            rules: { required: true },
            needToValidate: function() { return !!this.get('regionEditPermission') && this.get('city').length > 0 }
        }
    },
    FIO: {
        type: 'string',
        validation: {
            rules: { required: true }
        }
    },
    phone: {
        type: 'string',
        validation: {
            rules: { required: true }
        }
    },
    email: {
        type: 'string',
        validation: {
            validate: function(value) { return BEM.blocks['i-utils'].emailRegExp().test(value) }
        }
    },
    regionEditPermission: 'boolean',
    manager_use_crm: 'boolean',
    can_manage_price_packages: 'boolean',
    can_approve_price_packages: 'boolean',
    captcha_freq: { type: 'blank-number', precision: 0 },
    autoban_bonus: { type: 'blank-number', precision: 0 },
    banner_count_limit: { type: 'blank-number', precision: 0 },
    keyword_count_limit: { type: 'blank-number', precision: 0 },
    feed_count_limit: { type: 'blank-number', precision: 0 },
    feed_max_file_size: { type: 'blank-number', precision: 0 },
    show_agency_contacts: 'boolean',
    agency_email_to_chief: 'boolean',
    can_copy_ctr: 'boolean',
    agency_allow_pay: 'boolean',
    agency_disallow_money_transfer: 'boolean',
    show_fa_teaser: 'boolean',
    allow_device_targeting: 'boolean',
    is_developer: 'boolean',
    is_super_manager: 'boolean',
    not_resident: 'boolean',
    no_display_hrefs: 'boolean',
    is_favicon_blocked: 'boolean',
    sendAgencyMcbLetters: 'boolean',
    sendAgencyDirectLetters: 'boolean',
    AllowAgencyMassADVQ: 'boolean',
    allow_create_scamp_by_subclient: 'boolean',
    allowClientsWithoutWallet: 'boolean',
    defaultClientsWithWallet: 'boolean',
    agencyOptions: {
        type: 'string',
        internal: true,
        dependsFrom: ['allowClientsWithoutWallet', 'defaultClientsWithWallet'],
        calculate: function() {
            return JSON.stringify({
                allow_clients_without_wallet: (+this.get('allowClientsWithoutWallet')).toString(),
                default_clients_with_wallet: (+this.get('defaultClientsWithWallet')).toString()
            })
        }
    },
    notify_about_new_domains: 'boolean',
    hidden_status: 'boolean',
    statusBlocked: 'boolean',
    statusYandexAdv: 'boolean',
    showOnYandexOnly: 'boolean',
    isSuperPlacer: 'boolean',
    isSuperMedia: 'boolean',
    is_bad_passport_karma: 'boolean',
    force_multicurrency_teaser: 'boolean',
    modify_convert_allowed: 'boolean',
    disallow_money_transfer: 'boolean',
    user_lang: 'string',
    description: 'string',
    allowed_ips: 'string',
    region_id: 'string',
    work_currency: 'string',
    video_blacklist_size_limit: {
        type: 'blank-number',
        precision: 0,
        default: 20
    },
    general_blacklist_size_limit: {
        type: 'blank-number',
        precision: 0,
        default: 1000
    },
    report_name: 'string',
    social_advertising: 'boolean',
    default_disallowed_page_ids: 'string',
    default_allowed_domains: 'string'
});
