BEM.MODEL.decl('m-mol-stat-data', {

    'detailed-rows': {
        type: 'models-list',
        modelName: 'm-mol-stat-data-row',
        validation: {
            rules: {
                deep: true
            }
        }
    },

    head: {
        type: 'model',
        modelName: 'm-mol-stat-data-head-row',
        validation: {
            rules: {
                deep: true
            }
        }
    },

    'fake-head': {
        type: 'model',
        modelName: 'm-mol-stat-data-head-row',
        validation: {
            rules: {
                deep: true
            }
        }
    }

}, {

    /**
     * Инициализация событий
     */
    initEvents: function() {
        this
            .on('head fake-head', 'change', this._syncHeadModels, this)
            .on('detailed-rows', 'change', function(e, data) {
                var isMassAction = data.source === 'main';

                if (!isMassAction) {
                    switch (data.innerField) {
                        case 'search_query_checkbox':
                        case 'contextcond_ext_checkbox':
                            this._checkMainCheckbox(data.innerField);
                    }
                }
            }, this);

        this.get('head')
            .on('search_query_checkbox contextcond_ext_checkbox', 'change', function(e, data) {
                data.source !== 'check-main' && this._checkChildrenCheckboxes(data);
            }, this);
    },

    /**
     * Синхронизирует плавающий и статический хедер
     * @param {Event} event
     * @param {Object} data
     * @private
     */
    _syncHeadModels: function(event, data) {
        this.get(data.field === 'head' ? 'fake-head' : 'head')
            .update(this.get(data.field).toJSON());
    },

    /**
     * Возвращает статус фразы по названию поля чекбокса
     * @param {Object} model
     * @param {String} field
     * @returns {String}
     * @private
     */
    _getStatus: function(model, field) {
        return model.get({
            search_query_checkbox: 'search_query_status',
            contextcond_ext_checkbox: 'ext_phrase_status'
        }[field]);
    },

    /**
     * Выставляет дочерним полям-чекбоксам, значение главного
     * @param {Object} data
     * @private
     */
    _checkChildrenCheckboxes: function(data) {
        this.get('detailed-rows').forEach(function(row) {
            if (this._getStatus(row, data.field) !== 'added') {
                row.set(data.field, data.value, { source: 'main' });
            }
        }, this);
    },

    /**
     * Выставляет значение главному полю-чекбоксу относительно состояния дочерних
     * @param {String} field
     * @private
     */
    _checkMainCheckbox: function(field) {
        var isAllChecked = this.get('detailed-rows').every(function(row) {
            return row.get(field);
        });

        this.get('head')
            .set(field, isAllChecked, { source: 'check-main' });
    },

    /**
     * Собирает информацию о группах в которых состоят фразы
     * @returns {Object}
     */
    getGroupsInfo: function() {
        return this.get('detailed-rows').reduce(function(result, row) {
            if (!result[row.get('adgroup_id')]) {
                result[row.get('adgroup_id')] = {
                    groupName: row.get('adgroup_name'),
                    adgroupId: row.get('adgroup_id'),
                    campName: row.get('camp_name'),
                    cid: row.get('cid')
                };
            }

            return result;
        }, {});
    },

    /**
     * Возвращает данные для ajaxPrepareStatPhrases
     *  подробнее:
     *  https://wiki.yandex-team.ru/Direkt/TechnicalDesign/mol-add-plus-phrases/#kontrollerajaxpreparestatphrases
     * @returns {Array}
     */
    getSelectedPhrasesData: function() {
        var phrasesByGroup = {}; // складываем фразы по группам, что бы исключить дубликаты

        return this.get('detailed-rows').reduce(function(result, row) {
            var groupPhrases,
                rowData = row.toJSON(),
                adgroupId = rowData.adgroup_id;

            phrasesByGroup[adgroupId] || (phrasesByGroup[adgroupId] = {});
            groupPhrases = phrasesByGroup[adgroupId];

            if (rowData.search_query &&
                !groupPhrases[rowData.search_query] &&
                rowData.search_query_status !== 'added' &&
                rowData.search_query_checkbox) {

                result.push({
                    pid: adgroupId,                            // id группы
                    src_phrase: rowData.search_query,          // текст фразы-источника (ПЗ/ДРФ)
                    stat_target_phrase_id: rowData.phrase_id,  // опционально, id фразы клиента на которую есть статистика в связке с ПЗ из src_phrase
                    src_type: 'search_query',                  // тип фразы-источника (ПЗ/ДРФ),
                    report_row_hash: rowData.report_row_hash   // Логирование DIRECT-70871
                });

                groupPhrases[rowData.search_query] = true;
            }

            if (rowData.phrase &&
                !groupPhrases[rowData.phrase] &&
                rowData.ext_phrase_status !== 'added' &&
                rowData.contextcond_ext_checkbox) {

                result.push({
                    pid: adgroupId,                            // id группы
                    src_phrase: rowData.phrase,                // текст фразы-источника (ПЗ/ДРФ)
                    stat_target_phrase_id: rowData.phrase_id,  // опционально, id фразы клиента на которую есть статистика в связке с ПЗ из src_phrase
                    src_type: 'ext_phrase',                    // тип фразы-источника (ПЗ/ДРФ),
                    report_row_hash: rowData.report_row_hash   // Логирование DIRECT-70871
                });

                groupPhrases[rowData.phrase] = true;
            }

            return result;
        }, []);
    },

    /**
     * Проверяет, выбран ли хоты бы один элемент соответствующий переданному field
     * @param {String} field
     * @returns {Boolean}
     */
    isAnyChecked: function(field) {
        return this
            .get('detailed-rows')
            .some(function(row) { return row.get(field); });
    },

    _statusFieldByType: {
        search_query: 'search_query_status',
        ext_phrase: 'ext_phrase_status'
    },

    /**
     * Возвращает идентификатор строки на основе фразы, группы и типа фразы
     * TODO: можно прибегнуть к хешированию, MD5? O_o
     * @param {String} type
     * @param {String} phrase
     * @param {String} adgroupId
     * @returns {string}
     */
    buildKey: function(type, phrase, adgroupId) {
        return [type, phrase, adgroupId].join('#');
    },

    /**
     * Обновляет статус фраз
     * @param {String} type
     * @param {String} phrase
     * @param {String} adgroupId
     * @param {String} status
     */
    setStatusByIndex: function(type, phrase, adgroupId, status) {
        var phrasesIndex = this.getPhrasesIndex(),
            key = this.buildKey(type, phrase, adgroupId);

        if (phrasesIndex[key]) {
            phrasesIndex[key].forEach(function(model) {
                model.set(this._statusFieldByType[type], status);
            }, this);
        }
    },

    _phraseByStatusField: {
        search_query_status: 'search_query',
        ext_phrase_status: 'phrase'
    },

    /**
     * Проверяет, есть ли доступные для добавления фразы по statusField
     * @param {String} statusField
     * @returns {Boolean}
     */
    hasPhrasesForAdding: function(statusField) {
        return this
            .get('detailed-rows')
            .some(function(row) {
                return row.get(this._phraseByStatusField[statusField]) && row.get(statusField) !== 'added';
            }, this);
    },

    /**
     * Возвращает объект, где по ключу buildKey складываются ссылки на модели строк
     * Используется для поиска исходных фраз после успешного редактирования b-stat-table-phrases-popup
     * @returns {Object}
     */
    getPhrasesIndex: function() {
        if (this._phrasesIndex) {
            return this._phrasesIndex;
        }

        var _this = this;

        return this._phrasesIndex = this.get('detailed-rows')
            .reduce(function(result, row) {
                var searchIndex = _this.buildKey('search_query', row.get('norm_search_query'), row.get('adgroup_id')),
                    phraseIndex = _this.buildKey('ext_phrase', row.get('norm_ext_phrase'), row.get('adgroup_id'));

                result[searchIndex] || (result[searchIndex] = []);
                result[phraseIndex] || (result[phraseIndex] = []);

                result[phraseIndex].push(row);
                result[searchIndex].push(row);

                return result;
            }, {});
    }

});
