BEM.MODEL.decl({ name: 'm-money-transfer-campaign-from', baseModel: 'm-money-transfer-campaign' }, {
    /**
     * флаг - выполняется ли перенос с кампании
     */
    isTransferring: {
        type: 'boolean',
        dependsFrom: ['amount'],
        calculate: function() {
            return this.get('amount') > 0;
        }
    },

    /**
     * флаг - выполняется ли перенос всех средств
     */
    isTransferAll: {
        type: 'boolean',
        dependsFrom: ['amount', 'isTransferring'],
        calculate: function() {
            return this.get('amount') && (this.get('amount') == this.get('available'));
        }
    },

    /**
     * сумма переноса
     */
    amount: {
        type: 'number',
        default: 0,
        preprocess: function(val) {
            var available = this.model.get('available'),
                value = !val ?
                    0 :
                    typeof val !== 'number' ?
                        parseFloat(val.replace(/\s/g, '').replace(/[//,.юЮбБ<>]/gi, '.')) || 0 :
                        val ;

            return value > available ? available : value;
        }
    },

    /**
     * "тип" кампании - определяет находится ли кампания под общим счетом
     */
    mediaType: 'string'
});
