BEM.MODEL.decl({ name: 'm-money-transfer-campaign-to', baseModel: 'm-money-transfer-campaign' }, {
    /**
     * флаг - выполняется ли перенос на кампанию
     */
    isReceiving: {
        type: 'boolean',
        dependsFrom: ['amount'],
        calculate: function() {
            return this.get('amount') > 0;
        }
    },

    /**
     * флаг - отмечена ли кампания для равномерного переноса средств
     */
    isEqualReceive: {
        type: 'boolean',
        default: false
    },

    /**
     * флаг - выполняется ли в настоящее время перенос поровну между кампаниями
     */
    isEqualReceiveMode: {
        type: 'boolean',
        default: false
    },

    /**
     * сумма переноса
     */
    amount: {
        type: 'number',
        default: 0,
        preprocess: function(val) {

            return !val ?
                0 :
                typeof val !== 'number' ?
                    parseFloat(val.replace(/\s/g, '').replace(/[//,.юЮбБ<>]/gi, '.')) || 0 :
                    val;
        }
    }
});
