BEM.MODEL.decl('m-money-transfer-campaign', {
    /**
     * id кампании
     */
    cid: 'number',

    /**
     * название кампании
     */
    name: 'string',

    /**
     * состояние кампании
     */
    status: {
        type: 'enum',
        enum: ['activating', 'stopping', 'stop', ''],
        default: ''
    },

    /**
     * сумма переноса
     */
    amount: {
        type: 'number',
        default: 0
    },

    /**
     * id агентства
     */
    agencyid: 'number',

    /**
     * доступная к переносу сумма
     */
    available: {
        type: 'number',
        default: 0
    },

    /**
     * остаток средств на кампании
     */
    remaining: {
        type: 'number',
        default: 0
    },

    /**
     * флаг - возможно ли перенести средства на кампанию или с нее
     */
    isDisabled: 'boolean',

    /**
     * набор полей по которым выполняется поиск
     */
    searchFields: {
        type: 'array',
        default: ['name', 'cid']
    }
}, {
    searchInFields: function(strArray, foundCallback, notFoundCallback) {
        var searchFields = this.get('searchFields'),
            found = [];

        searchFields.forEach(function(field, i) {
            var fieldValueStr = this.get(field).toString().toLowerCase();
            strArray.forEach(function(part) {
                if (fieldValueStr.indexOf(part) >= 0) {
                    found.push(field);
                }
            }, this);
        }, this);

        if (found.length) {
            found.forEach(function(fieldName) {
                foundCallback(fieldName);
            })
        } else {
            notFoundCallback();
        }
    }
});
