BEM.MODEL.decl({ name: 'm-money-transfer-from', baseModel: 'm-money-transfer' }, {
    /**
     * Список кампаний
     */
    campaigns: {
        type: 'models-list',
        modelName: 'm-money-transfer-campaign-from'
    }
}, {
    /**
     * Сбрасывает кампании campaigns, если campaigns не указан сбрасывает все кампании списка
     * @param {BEM.MODEL[]} campaigns массив моделей 'm-money-transfer-campaign'
     */
    resetCampaigns: function(campaigns) {
        (campaigns || this.get('campaigns')).forEach(function(camp) {
            camp.update({
                amount: 0,
                isTransferring: false
            })
        })
    },

    /**
     * Возвращает массив кампаний с которых выполняется перенос
     * @returns {BEM.MODEL[]} массив моделей 'm-money-transfer-campaign'
     */
    getTransferringCampaigns: function() {
        return this.get('campaigns').where({ isTransferring: true });
    },

    /**
     * Устанавливает флаг isTransferring: true кампании campaign, если кампании не isDisabled
     * @param {BEM.MODEL} campaign модель кампании типа m-money-transfer-campaign
     */
    selectOneCamp: function(campaign) {
        !campaign.get('isDisabled') && campaign.set('isTransferring', true);
    },

    /**
     * Устанавливает amount кампании campaign, равный 0 или доступной для переноса сумме
     * @param {BEM.MODEL} campaign модель кампании типа m-money-transfer-campaign
     * @param {Boolean} toggle флаг, true ? amount = available : 0
     */
    toggleOneCampAmount: function(campaign, toggle) {
        campaign.set('amount', toggle ? campaign.get('available') : 0)

    },

    /**
     * Устанавливает amount всех кампании campaigns, равный доступной для переноса сумме
     * @param {BEM.MODEL[]} campaigns массив моделей кампании типа m-money-transfer-campaign
     */
    setAllCampsMaxAmount: function(campaigns) {
        campaigns.forEach(function(camp) {
            camp.set('amount', camp.get('available'))
        });
    }
});
