BEM.MODEL.decl('m-money-transfer', {
    campaigns: {
        type: 'models-list',
        modelName: 'm-money-transfer-campaign'
    }
}, {
    /**
     * Возвращает массив кампаний, доступные для переноса или получения
     * @returns {BEM.MODEL[]} массив моделей 'm-money-transfer-campaign'
     */
    getNotDisabledCampaigns: function() {
        return this.get('campaigns').where({ isDisabled: false });
    },

    /**
     * Возвращает сумму доступных для переноса средств по выбранным кампаниям
     * @param {BEM.MODEL[]} campaigns список кампаний
     * @returns {Number} сумма значений полей 'available' кампаний
     */
    getSumOfAvailableValue: function(campaigns) {
        return campaigns.reduce(function(sum, camp) {
            return sum + camp.get('available');
        }, 0);
    },

    /**
     * Возвращает отсортированный список кампаний в модели
     * @param {String} sortField имя поля по которому производится сортировка
     * @param {String} direction направление сортировки (asc|desc)
     * @returns {BEM.MODEL[]} массив моделей 'm-money-transfer-campaign'
     */
    getSortedCampaignList: function(sortField, direction) {
        var camps = this.get('campaigns').map(function(camp) {
                return camp;
            }),
            sorted = camps.sort(function(a, b) {
                var compA = a.get(sortField),
                    compB = b.get(sortField);

                if (sortField == 'name') {
                    compA = compA.toLowerCase(),
                    compB = compB.toLowerCase()

                    return (!direction || direction == 'desc') ? compA.localeCompare(compB) : compB.localeCompare(compA)
                } else {

                    if (!direction || direction == 'desc') {
                        return compA > compB ? -1 : compA < compB ? 1 : 0;
                    } else {
                        return compA < compB ? -1 : compA > compB ? 1 : 0;
                    }
                }
            });

        return sorted;
    },

    /**
     * Устанавливает amount кампании campaign, равный amountValue
     * @param {BEM.MODEL} campaign модель кампании типа m-money-transfer-campaign
     * @param {Number | String} amountValue - новое значение amount
     */
    setOneCampAmount: function(campaign, amountValue) {
        campaign.set('amount', amountValue);
    },

    /**
     * Устанавливает amount всех кампании campaigns, равный amountValue
     * @param {BEM.MODEL[]} campaigns массив моделей кампании типа m-money-transfer-campaign
     * @param {Number | String} amountValue - новое значение amount
     */
    setAllCampsAmount: function(campaigns, amountValue) {
        campaigns.forEach(function(model) {
            model.set('amount', amountValue)
        });
    }
});
