u.register({

    'm-organization': {

        /**
         * Преобразовывает серверные данные организации в модельные
         * @param {Object} options
         * @param {Object} options.organization
         * @returns {*}
         */
        transformData: function(options) {
            var organization = options.organization,
                data = [
                    'permalink',
                    'modelId',
                    'profileUrl',
                    'phone',
                    'address',
                    'isOnline'
                ].reduce(function(data, name) {
                    data[name] = organization[name];
                    return data;
                }, {});

            data.workTimes = organization.workTimes ? u.mapWorkTimesFromApi(organization.workTimes) : '';

            return data;
        }
    }
});
