block('m-phrase-bidable').def()(function() {
    var phrase = this.ctx.phrase,
        group = this.ctx.group,
        data = (
            this.data.view_only || this.data.archived == 'Yes' ? [
                'minus_words',
                'key_words',
                'id'
            ] : [
                'quality_score',
                'id',
                'minus_words',
                'key_words',
                'phrase_unglued_suffix',
                'fixation',
                'key_words_fix_on',
                'key_words_fix_off',
                'unglued',
                'stopword_fixated',
                'phrase_minus_words_limit'
            ]).reduce(function(data, name) {
                data[name] = phrase[name];

                return data;
            }, {});

    data.modelId = data.modelId || data.id;

    var MINUS_WORDS_TRIM_LIMIT = 20;

    data.campDMName = u.campaign.getCampaignModelName(this.data.campaign.mediaType);

    //todo - на сервер
    data.phrase_minus_words_limit = MINUS_WORDS_TRIM_LIMIT;

    return u._.extend(
        data,
        applyCtx({
            block: 'm-bidable',
            bidable: phrase,
            group: group,
            campaign: this.data.campaign
        })
    );
});
