BEM.MODEL.decl({ model: 'm-phrase-bidable', baseModel: 'm-bidable' }, {
    //id фразы
    id: 'string',
    //id модели фразы
    modelId: {
        type: 'string',
        internal: true
    },

    cbroker: {
        type: 'object',
        internal: true
    },

    status: 'string',
    //фраза целиком
    phrase: {
        type: 'string',
        dependsFrom: ['key_words', 'minus_words', 'unglued', 'stopword_fixated'],
        calculate: function() {
            var result = [];

            result.push(this.get('stopword_fixated') ?
                this.get('key_words_fix_on') :
                this.get('key_words_fix_off') || this.get('key_words'));

            if (!u.minusWords.isEmpty(this.get('minus_words'))) {
                result.push(u.minusWords.arrayToString(this.get('minus_words')));
            }

            if (this.get('unglued')) {
                result.push(this.get('phrase_unglued_suffix'));
            }

            return result.join(' ');
        }
    },
    //минус-слова
    minus_words: {
        type: 'array'
    },
    showsForecast: 'string',
    //ключевики без isInArrayisInArray
    key_words: 'string',

    //обрезанный вариант, для отображения DIRECT-15890
    key_words_short: {
        type: 'string',
        dependsFrom: ['key_words'],
        internal: true,
        calculate: function() {
            return this.get('key_words').split(' ').map(function(word) {
                var KEY_WORD_LIMIT = 40;

                return u.hellipCut(word, KEY_WORD_LIMIT, '...');
            }).join(' ');
        }
    },
    //добавленные автоматически минус-слова
    phrase_unglued_suffix: 'string',

    quality_score: { type: 'number', precision: 1 },
    verdicts: 'array',

    //массив с автоматически измененными стоп-словами: [[измененное+слово, старое слово], [i+phone, i phone], [i+pad, i pad]]
    fixation: 'array',

    //ключевики с включенной расклейкой стоп-слов
    key_words_fix_on: 'string',

    //ключевики с выключенной расклейкой стоп-слов
    key_words_fix_off: 'string',

    //включена расклейка
    unglued: {
        type: 'boolean',
        internal: true
    },

    //включена фиксация по стоп-списку
    stopword_fixated: {
        type: 'boolean',
        internal: true
    },

    phrase_minus_words_limit: {
        type: 'number',
        internal: true
    },

    //Параметры фразы, задаются в xls или коммандере
    param1: { type: 'string' },
    param2: { type: 'string' }

});

BEM.MODEL.decl({ model: 'm-phrase-tmp', baseModel: 'm-phrase-bidable' }, {

    // автотаргетинг на поиске
    search_stop: {
        type: 'number'
    },

    // автотаргетинг в сети
    net_stop: {
        type: 'number'
    }

});
