BEM.MODEL.decl('m-phrase-text', {
    //id фразы
    id: 'string',
    modelId: 'string',
    status: 'string',
    is_deleted: 'boolean',
    is_suspended: 'boolean',
    state: {
        type: 'enum',
        enum: ['active', 'context', 'low_ctr', 'declined', 'new'],
        default: 'new'
    },

    //фраза целиком
    phrase: {
        type: 'string',
        dependsFrom: ['key_words', 'minus_words'],
        calculate: function() {
            return u.minusWords.isEmpty(this.get('minus_words')) ?
                this.get('key_words') :
                this.get('key_words') + ' ' + u.minusWords.arrayToString(this.get('minus_words'));
        }
    },

    //минус-слова
    minus_words: {
        type: 'array'
    },
    //ключевики
    key_words: 'string',

    //Параметры фразы, задаются в xls или коммандере
    param1: { type: 'string' },
    param2: { type: 'string' }
});
