BEM.MODEL.decl('m-prices-constructor', {
    //цена на контексте
    price_context: {
        type: 'blank-number',
        validation: {
            rules: {
                required: { text: iget2('m-prices-constructor', 'bid-required', 'Неверно указана ставка') },
                gte: function() { return this.getMaxPriceRule('context') },
                lte: function() { return this.getMinPriceRule('context') }
            },
            needToValidate: function() {
                return !this.get('is_context_disabled');
            }
        }
    },
    //цена на поиске
    price_search: {
        type: 'blank-number',
        validation: {
            rules: {
                required: { text: iget2('m-prices-constructor', 'bid-required', 'Неверно указана ставка') },
                gte: function() { return this.getMaxPriceRule('search') },
                lte: function() { return this.getMinPriceRule('search') }
            },
            needToValidate: function() {
                return !this.get('is_search_disabled');
            }
        }
    },

    //значение переключателя "на поиске/контексте/везде"
    platform: { type: 'enum', enum: ['search', 'context', 'both'], default: 'search' },

    // объем трафика в % на поиске
    position_ctr_correction: {
        type: 'enum',
        enum: ['max', '100', '95', '90', '85', '80', '75', '65', '15', '5'],
        default: '100'
    },

    //% охвата аудитории
    context_scope: {
        type: 'enum',
        enum: ['100', '90', '80', '70', '60', '50', '40', '30', '20', '10'],
        default: '100'
    },

    //+n % от ставки на поиске
    proc_search: {
        type: 'blank-number',
        precision: 0,
        validation: {
            rules: {
                required: { text: iget2('m-prices-constructor', 'neverno-ukazany-procenty-na', 'Неверно указаны проценты на поиске') },
                gte: function() { return this.getMaxPercRule('search') },
                lte: function() { return this.getMinPercRule('search') }
            },
            needToValidate: function() {
                return !this.get('is_simple') && !this.get('is_search_disabled');
            }
        }
    },
    //+n % от ставки на контексте
    proc_context: {
        type: 'blank-number',
        precision: 0,
        validation: {
            rules: {
                required: { text: iget2('m-prices-constructor', 'neverno-ukazany-procenty-v', 'Неверно указаны проценты в сетях') },
                gte: function() { return this.getMaxPercRule('context') },
                lte: function() { return this.getMinPercRule('context') }
            },
            needToValidate: function() {
                return !this.get('is_simple') && !this.get('is_context_disabled');
            }
        }
    },
    //чекбокс "для фраз"
    phrases_context: 'boolean',
    //чекбокс "для условий ретаргетинга"
    retargetings_context: 'boolean',
    //конструктор ставок недоступен
    is_disabled: 'boolean',
    //недоступно редактирование ставки на поиске
    is_search_disabled: 'boolean',
    //недоступно редактирование ставки на контексте
    is_context_disabled: 'boolean',
    //чекбокс "контекст" в отдельном  размещении
    context_toggle: 'boolean',
    //чекбокс "поиск" в отдельном  размещении
    search_toggle: 'boolean',
    //показываем сокращенный конструктор ставок
    is_simple: 'boolean',
    //текущая валюта конструктора ставок
    currency: 'string'
}, {
    getMinPriceRule: function(platform) {
        var currencyName = this.get('currency'),
            currency = u.currencies.get(currencyName);

        return {
            value: currency.MIN_PRICE,
            text: ((platform === 'search' ?
                iget2('m-prices-constructor', 'bid-search-lte-error', 'Ставка на поиске не может быть меньше') :
                iget2('m-prices-constructor', 'bid-context-lte-error', 'Ставка в сетях не может быть меньше')) + ' ' + u.currencies.formatConst(currencyName, 'MIN_PRICE'))
        };
    },

    getMaxPriceRule: function(platform) {
        var currencyName = this.get('currency'),
            currency = u.currencies.get(currencyName);

        return {
            value: currency.MAX_PRICE,
            text: ((platform === 'search' ?
                iget2('m-prices-constructor', 'bid-search-gte-error', 'Ставка на поиске не может быть больше') :
                iget2('m-prices-constructor', 'bid-context-gte-error', 'Ставка в сетях не может быть больше')) + ' ' + u.currencies.formatConst(currencyName, 'MAX_PRICE'))
        };
    },

    getMinPercRule: function(platform) {
        var min = 0;

        return {
            value: min,
            text: (platform === 'search' ?
                iget2('m-prices-constructor', 'procenty-na-poiske-ne', 'Проценты на поиске не могут быть меньше') :
                iget2('m-prices-constructor', 'procenty-v-setyah-ne', 'Проценты в сетях не могут быть меньше')) + ' ' + min + '%'
        };
    },

    getMaxPercRule: function(platform) {
        var max = 1000;

        return {
            value: max,
            text: (platform === 'search' ?
                iget2('m-prices-constructor', 'procenty-na-poiske-ne-102', 'Проценты на поиске не могут быть больше') :
                iget2('m-prices-constructor', 'procenty-v-setyah-ne-103', 'Проценты в сетях не могут быть больше')) + ' ' + max + '%'
        };
    }
});
