block('m-retargeting-bidable').def()(function() {
    var condition = this.ctx.condition,
        group = this.ctx.group,
        data = [
            'ret_cond_id',
            'ret_id',
            'condition_name',
            'condition_name_escape'
        ].reduce(function(data, name) {
            data[name] = condition[name];

            return data;
        }, {});

    condition.type == 'retargeting'; // eslint-disable-line no-unused-expressions

    data.modelId = data.modelId || data.ret_cond_id;

    data.campaignId = this.data.campaign.cid || '0';
    data.adgroup_id = group.adgroup_id || '0';

    data.campDMName = u.campaign.getCampaignModelName(this.data.campaign.mediaType);

    // нужно для сортировки
    data.phrase = data.condition_name;

    data.conditionsType = data.conditions_type;

    return u._.extend(
        data,
        applyCtx({
            block: 'm-bidable',
            bidable: condition,
            group: group,
            campaign: this.data.campaign
        }));
});
