BEM.MODEL.decl('m-retargeting-condition', {
    ret_id: 'string',
    ret_cond_id: 'id',
    condition_name: 'string',
    condition_name_escape: {
        type: 'string',

        calculate: function() {
            var tagsToReplace = {
                '&': '&amp;',
                '<': '&lt;',
                '>': '&gt;'
            };

            return u.hellipCut(this.get('condition_name').replace(/[&<>]/g, function(tag) {
                return tagsToReplace[tag] || tag;
            }), 50);
        },
        dependsFrom: 'condition_name'
    },

    domains: 'string',
    condition_desc: 'string',
    //todo
    is_accessible: 'boolean',
    condition_desc_escape: {
        type: 'string',

        calculate: function() {
            var tagsToReplace = {
                '&': '&amp;',
                '<': '&lt;',
                '>': '&gt;'
            };

            return u.hellipCut(this.get('condition_desc').replace(/[&<>]/g, function(tag) {
                return tagsToReplace[tag] || tag;
            }), 30);
        },
        dependsFrom: 'condition_desc'
    },
    groups: 'array',

    /**
     * кампании в которых используется условие
     * Если условие используется одновременно в подборе и коректировке, оно задваивается
     * такие условия схлопваем в модели, тикет на этот "баг" DIRECT-64744
     */
    campaigns: {
        type: 'array',
        preprocess: function(val) {
            var obj = val.reduce(function(obj, item) {
                obj[item.cid] = item;
                return obj;
            }, {});

            return Object.keys(obj).map(function(key) {
                return this[key];
            }, obj);
        }
    },
    clicks: 'number',
    shows: 'number',
    ctr: 'string',
    is_suspended: 'boolean',
    is_negative: 'boolean', // условия только с отрицательными группами используются для корректировки новым клиентам
    state: {
        type: 'enum',
        enum: ['active', 'context', 'search', 'low_ctr', 'declined', 'new'],
        default: 'new'
    }
});
