(function() {
    BEM.MODEL.decl('m-stat-phrase-bidable', {

        modelId: {
            type: 'id',
            internal: true
        },

        adgroup_id: {
            type: 'string',
            default: ''
        },

        cid: {
            type: 'string',
            default: ''
        },

        bidForSearchLink: {
            type: 'string',
            default: ''
        },

        norm_phrase: {
            type: 'string',
            default: ''
        },

        norm_phrase_unquoted: {
            type: 'string',
            default: ''
        },

        report_row_hash: 'string',

        phrase: {
            type: 'string',
            default: '',
            format: function(value) {
                var keyWords = u.phraseFormatter.getKeyWords(value),
                    minusWords = u.phraseFormatter.getMinusWords(value);

                // исправить после DIRECT-51480, методы minusWords будут работать верно
                minusWords = u.minusWords.arrayToString(u.minusWords.stringToArray(minusWords));

                return [keyWords, minusWords].join(' ').trim();
            },
            validation: function() {
                return {
                    rules: {
                        required: { text: iget2('m-stat-phrase-bidable', 'klyuchevaya-fraza-ne-mozhet', 'Ключевая фраза не может быть пустой') },
                        maxlength: {
                            validate: function(value) {
                                value = value
                                    .replace(/\s+/g, ' ')
                                    .replace(/-(.*)-/, function(text) {
                                        // При подсчете длины фразы не учитываются `!` и `+` в минус-словах
                                        return text.replace(/[!+]/, '');
                                    });

                                return value.length <= u.consts('MAX_PHRASE_LENGTH')
                            },
                            text: iget2('m-stat-phrase-bidable', 'prevyshena-dopustimaya-dlina-stroki', 'Превышена допустимая длина строки в {foo} символов', {
                                foo: u.consts('MAX_PHRASE_LENGTH')
                            })
                        },
                        maxWordsInKeyphrase: {
                            validate: function(value) {
                                var keyWords = u.phraseFormatter
                                    .getKeyWords(value)
                                    .replace(/\s+/g, ' ')
                                    .split(/\s/g)
                                    .reduce(function(result, word) {
                                        // На сервере с цифрами (да и с точками в целом) такая логика:
                                        // Числа с точкой оставляем как есть, а остальные точки считаем отдельными словами
                                        // https://st.yandex-team.ru/DIRECT-58707#1479888894000
                                        if (/^\d+\.\d+$/.test(word)) {
                                            result.push(word);

                                            return result;
                                        } else {
                                            return result.concat(word.split('.'));
                                        }
                                    }, []);

                                return u._.compact(keyWords).length <= u.consts('MAX_WORDS_IN_KEYPHRASE');
                            },
                            text: iget2(
                                'm-stat-phrase-bidable',
                                'klyuchevaya-fraza-ne-mozhet-104',
                                'Ключевая фраза не может состоять более чем из {foo} слов',
                                {
                                    foo: u.consts('MAX_WORDS_IN_KEYPHRASE')
                                }
                            )
                        },
                        serverErrors: {
                            validate: function() {
                                return !this.get('server_errors');
                            },
                            text: this.get('server_errors')
                        }
                    }
                };
            }
        },

        src_phrase: {
            type: 'string',
            default: ''
        },

        src_type: {
            type: 'string',
            default: ''
        },

        currency: {
            type: 'string'
        },

        has_price: {
            type: 'boolean',
            default: true
        },

        has_price_context: {
            type: 'boolean',
            default: true
        },

        status: {
            type: 'string',
            default: ''
        },

        server_errors: {
            type: 'string',
            dependsFrom: 'phrase',
            calculate: function() {
                return '';
            }
        },

        price: {
            type: 'rounded-number',
            validation: function() {
                var currencyName = this.get('currency'),
                    currency = u.currencies.get(currencyName);

                return {
                    rules: {
                        required: { text: iget2('m-stat-phrase-bidable', 'stavka-dolzhna-byt-chislom', 'Ставка должна быть числом') },
                        gte: {
                            value: currency.MAX_PRICE,
                            text: iget2('m-stat-phrase-bidable', 'stavka-dolzhna-byt-ne', 'Ставка должна быть не больше {foo}', {
                                foo: u.currencies.formatConst(currencyName, 'MAX_PRICE')
                            })
                        },
                        lte: {
                            value: currency.MIN_PRICE,
                            text: iget2('m-stat-phrase-bidable', 'stavka-dolzhna-byt-ne-105', 'Ставка должна быть не меньше {foo}', {
                                foo: u.currencies.formatConst(currencyName, 'MIN_PRICE')
                            })
                        }
                    },
                    needToValidate: function() {
                        return this.get('has_price');
                    }
                };
            }
        },

        price_context: {
            type: 'rounded-number',
            validation: function() {
                var currencyName = this.get('currency'),
                    currency = u.currencies.get(currencyName);

                return {
                    rules: {
                        required: { text: iget2('m-stat-phrase-bidable', 'stavka-dolzhna-byt-chislom', 'Ставка должна быть числом') },
                        gte: {
                            value: currency.MAX_PRICE,
                            text: iget2('m-stat-phrase-bidable', 'stavka-dolzhna-byt-ne', 'Ставка должна быть не больше {foo}', {
                                foo: u.currencies.formatConst(currencyName, 'MAX_PRICE')
                            })
                        },
                        lte: {
                            value: currency.MIN_PRICE,
                            text: iget2('m-stat-phrase-bidable', 'stavka-dolzhna-byt-ne-105', 'Ставка должна быть не меньше {foo}', {
                                foo: u.currencies.formatConst(currencyName, 'MIN_PRICE')
                            })
                        }
                    },
                    needToValidate: function() {
                        return this.get('has_price_context');
                    }
                };
            }
        }

    });

})();
