(function() {
    var INDEX_CODE_HOUR = 'ABCDEFGHIJKLMNOPQRSTUVWX'.split(''),
        INDEX_WEEKDAY = [iget2('m-time-targeting', 'pn', 'Пн.'), iget2('m-time-targeting', 'vt', 'Вт.'), iget2('m-time-targeting', 'sr', 'Ср.'), iget2('m-time-targeting', 'cht', 'Чт.'), iget2('m-time-targeting', 'pt', 'Пт.'), iget2('m-time-targeting', 'sb', 'Сб.'), iget2('m-time-targeting', 'vs', 'Вс.')];

    BEM.MODEL.decl({ model: 'm-time-targeting', baseModel: 'm-time-targeting-base' }, {
        timeTargetPreset: {
            type: 'string',
            default: '',
            dependsFrom: 'timeTargetCode',
            calculate: function() {
                return this.get('timeTargetCode') === this.get('codeAllTime') ? 'all' : '';
            }
        },

        textShowTime: {
            type: 'string',
            dependsFrom: ['timeTargetCode', 'isAllTime'],
            calculate: function() {
                return this.get('isAllTime') ?
                    iget2('m-time-targeting', 'kruglosutochno', 'Круглосуточно') :
                    iget2('m-time-targeting', 'pokazyvat', 'Показывать') + ': ' + this.getTextDayHours(this.get('timeTargetCode'));
            }
        },
        timeTargetCode: 'string',
        timeTargetTable: 'data-table',

        timezoneRegionId: 'string',
        timezoneText: 'string',
        totalHours: { // сумма часов
            type: 'number',
            dependsFrom: 'timeTargetTable',
            calculate: function() {
                var count = 0;

                this.get('timeTargetTable').fullScan(function(cell, value) {
                    if (cell[0] > 4) return true;

                    value && count++;
                });

                return count;
            },
            format: function() {
                return this._raw.toString()
            },
            validation: {
                rules: {
                    lte: {
                        value: 40,
                        text: iget2('m-time-targeting', 'kampaniya-dolzhna-byt-vklyuchena', 'Кампания должна быть включена не менее 40 часов в рабочие дни')
                    }
                }
            }
        },

        textShowOnHolidays: {
            type: 'string',
            dependsFrom: [
                'mode',
                'intoAccountHolidays',
                'dontShowOnHolidays',
                'holidaysTo',
                'holidaysFrom',
                'holidaysTimeTargetLevel',
                'noExtend'
            ],
            calculate: function() {
                var text;

                if (this.get('intoAccountHolidays')) {
                    text = iget2('m-time-targeting', 'po-prazdnikam', 'По праздникам') + ': ' +
                        (this.get('dontShowOnHolidays') ?
                            iget2('m-time-targeting', 'ne-pokazyvat', 'не показывать') :
                            this.getTextShowOnHoliday(this.get('holidaysFrom'), this.get('holidaysTo')) +
                            (this.get('noExtend') || this.get('mode') !== 'extend' ?
                                '' :
                                this.getTextClickLevel(this.get('holidaysTimeTargetLevel'))));
                }

                return text;
            }
        },
        textShowOnWorkingWeekend: {
            dependsFrom: 'intoAccountWeekend',
            calculate: function() {
                return this.get('intoAccountWeekend') ?
                    iget2('m-time-targeting', 'rabochie-vyhodnye-po-raspisaniyu', 'Рабочие выходные: по расписанию перенесенного буднего дня') :
                    '';
            }
        },
        textClickLevel: {
            dependsFrom: [
                'timeTargetCode',
                'noExtend'
            ],
            calculate: function() {
                return (/[a-z]/).test(this.get('timeTargetCode')) && !this.get('noExtend') ?
                    iget2('m-time-targeting', 'dobavlena-korrektirovka-stavki-po', 'Добавлена корректировка ставки по времени') :
                    '';
            }
        },
        textTimezone: {
            dependsFrom: ['isAllTime', 'timezoneText'],
            calculate: function() {
                return !this.get('isAllTime') ? iget2('m-time-targeting', 'vremya', 'Время') + ': ' + this.get('timezoneText') : '';
            }
        },
        indexCodeHour: 'string',
        textDataHint: {
            type: 'string',
            dependsFrom: [
                'timeTargetCode',
                'textClickLevel',
                'textShowOnWorkingWeekend',
                'textShowOnHolidays',
                'textShowTime',
                'textTimezone',
                'noExtend'
            ],
            calculate: function() {
                return [
                    this.get('textShowTime'),
                    this.get('textShowOnHolidays'),
                    this.get('textShowOnWorkingWeekend'),
                    this.get('textTimezone'),
                    this.get('textClickLevel')
                ].filter(function(elem) {
                    return !!elem;
                }).map(function(elem) {
                    return BEMHTML.apply({
                        block: 'hint-row',
                        content: elem
                    })
                })
            }
        }

    }, {
        /**
         * Отдает время показа в виде строки.
         *
         * @param {String} code Код таргетинга.
         * @returns {String}
         */
        getTextDayHours: function(code) {
            var codesOfDays = this.getCodesOfDays(code),
                leader = null,
                trailer,
                texts = [];

            for (var dayIndex = 0; dayIndex < 7; dayIndex++) {
                var codeDay = codesOfDays[dayIndex];

                if (!codeDay) continue;

                // начало последовательности
                leader === null && (leader = dayIndex);

                // если последовательность не начнется, замыкаем и начинаем новую
                if (codesOfDays[dayIndex] != codesOfDays[dayIndex + 1]) {
                    trailer = dayIndex;
                    texts.push(this.getTextDayRange(leader, trailer) + ': ' + this.getTextDayTime(codeDay));
                    leader = null;
                }
            }

            return texts.join(', ');
        },

        /**
         * Отдает время показа в виде строки за определенный день.
         *
         * @param {String} codeDay Код таргетинга за определенный день.
         * @returns {String}
         */
        getTextDayTime: function(codeDay) {
            var day = [],
                leader = null,
                trailer,
                time = u.moment().minutes(0);

            INDEX_CODE_HOUR.forEach(function(hourCode, index) {
                if (~codeDay.indexOf(hourCode)) {
                    // проверяем на null, потому что 0 для нас true
                    leader === null && (leader = index);

                    // если отмечен последний час, замыкаем последовательность и сбрасываем лидирующий час
                    index === 23 && (trailer = 24) &&
                        day.push(
                            u['m-time-targeting'].getFormattedHours(leader) + '-' +
                            u['m-time-targeting'].getFormattedHours(trailer)
                        ) && (leader = null);
                } else {
                    // если есть последовательность, замыкаем и сбрасываем лидирующий час
                    (trailer = index) && leader !== null &&
                        day.push(
                            u['m-time-targeting'].getFormattedHours(leader) + '-' +
                            u['m-time-targeting'].getFormattedHours(trailer)
                        ) && (leader = null);
                }
            }, this);

            return day.join(', ');
        },

        /**
         * Отдает коды временного таргетинга по дня, с соответствием индексов WEEKDAY_NAMES.
         *
         * @param {String} code Код временного таргетинга.
         * @returns {Array}
         */
        getCodesOfDays: function(code) {
            var codesNormalized = [],
                codes = code.replace(/[a-z]+/g, '').match(/\d[A-X]+/g);

            codes && codes.forEach(function(code) {
                var split = code.match(/\d|[A-X]+/g);

                codesNormalized[split[0] - 1] = split[1];
            });

            return codesNormalized;
        },

        /**
         * Отдает дневной промежуток вида "пн.-сб." на основе индексов дней недели.
         *
         * @param {Number} from Индекс начала дня недели.
         * @param {Number} to Индекс конца дня недели.
         * @returns {String}
         */
        getTextDayRange: function(from, to) {
            return INDEX_WEEKDAY[from] + (from != to ? '-' + INDEX_WEEKDAY[to] : '');
        },

        /**
         * Отдает текст диапазона времени показа в праздничные дни.
         *
         * @param {Number} hourFrom Час начла показа.
         * @param {Number} hourTo Час конца показа.
         * @returns {String}
         */
        getTextShowOnHoliday: function(hourFrom, hourTo) {
            var time = u.moment().minute(0);

            return hourFrom !== undefined && hourTo !== undefined ?
                hourFrom === 0 && hourTo === 24 ?
                    iget2('m-time-targeting', 'kruglosutochno-106', 'круглосуточно') :
                    iget2('m-time-targeting', 'pokazyvat-s-s-do', 'показывать с {foo} до {bar}', {
                        foo: u['m-time-targeting'].getFormattedHours(hourFrom),
                        bar: u['m-time-targeting'].getFormattedHours(hourTo)
                    }) :
                '';
        },

        /**
         * Отдает уровень ставки в праздничные дни в виде текста.
         *
         * @param {String} level Уровень цены клика.
         * @returns {string}
         */
        getTextClickLevel: function(level) {
            level = +level;

            return level === 0 || level === 100 ?
                '' :
                ' (' + iget2('m-time-targeting', 'ogranichenie-stavki-na', 'ограничение ставки на уровне') + ' ' + u.escapeHTML(level) + '%)';
        }

    });
})();
