(function() {
    var TIN_LENGTH_FOR_LEGAL_ENTITY = 10,
        TIN_LENGTH_FOR_PERSON = 12;

    function getControlNumberForTin(weightCoefs, tinDigits) {
        var controlSum = tinDigits.reduce(
            function(sum, digit, index) {
                return sum + digit * (weightCoefs[index] || 0);
            },
            0
        );

        return (controlSum % 11) % 10;
    }

    BEM.MODEL.decl('m-user-settings', {
        email: {
            type: 'string',
            validation: {
                text: iget2('m-user-settings', 'nekorrektno-ukazan-email', 'Некорректно указан email'),
                validate: function(value) {
                    return BEM.blocks['i-utils'].emailRegExp().test(value);
                }
            }
        },

        /*
        * email для новостей и рекомендаций (DIRECT-51602)
        * */
        recommendations_email: {
            type: 'string',
            validation: {
                text: iget2('m-user-settings', 'nekorrektno-ukazan-email-dlya', 'Некорректно указан email для новостей и рекомендаций'),
                validate: function(value) {
                    return !value.length || BEM.blocks['i-utils'].emailRegExp().test(value);
                }
            }
        },

        fio: 'string',
        phone: {
            type: 'string',
            validation: {
                text: iget2('m-user-settings', 'nekorrektno-ukazan-nomer-telefona', 'Некорректно указан номер телефона'),
                validate: function(value) {
                    return !value.length || (value.match(/(\d)/g) || []).length > 3;
                }
            }
        },
        tin_type: {
            type: 'string',
            validation: {
                text: iget2('m-user-settings', 'tin-type-required', 'Укажите значение поля "Физическое/Юридическое лицо"'),
                validate: function(tin_type) {
                    return this.get('tin').trim() === '' || tin_type !== '';
                },
                needToValidate: function() {
                    return u.consts('isEditTinEnabledInUserSettings');
                },
            }
        },
        tin: {
            type: 'string',
            validation: {
                rules: {
                    shouldBeNumber: {
                        validate: function(tin) {
                            if (tin.match(/[^0-9]/)) {
                                return true;
                            }

                            return {
                                text: iget2('m-user-settings', 'tin-type-number', 'Неправильный ИНН. Вводите только цифры')
                            };
                        },
                        needToValidate: function(tin) {
                            return u.consts('isEditTinEnabledInUserSettings') && tin.length !== 0;
                        },
                    },
                    lengthForLegal: {
                        text: iget2(
                            'm-user-settings',
                            'length-for-legal',
                            'ИНН для юридических лиц должен содержать {count} символов',
                            { count: TIN_LENGTH_FOR_LEGAL_ENTITY }
                        ),
                        validate: function(tin) {
                            return tin.length === TIN_LENGTH_FOR_LEGAL_ENTITY;
                        },
                        needToValidate: function(tin) {
                            return u.consts('isEditTinEnabledInUserSettings') &&
                                this.get('tin_type') === 'legal' &&
                                tin.length !== 0;
                        },
                    },
                    lengthForPhysical: {
                        text: iget2(
                            'm-user-settings',
                            'length-for-physical',
                            'ИНН для физических лиц должен содержать {count} символов',
                            { count: TIN_LENGTH_FOR_PERSON }
                        ),
                        validate: function(tin) {
                            return tin.length === TIN_LENGTH_FOR_PERSON;
                        },
                        needToValidate: function(tin) {
                            return u.consts('isEditTinEnabledInUserSettings') &&
                                this.get('tin_type') === 'physical' &&
                                tin.length !== 0;
                        },
                    },
                    controlNumberForLegal: {
                        text: iget2('m-user-settings', 'control-number', 'Некорректный ИНН'),
                        validate: function(tin) {
                            var tinDigits = tin.split('').map(Number);

                            if (tinDigits[9] === getControlNumberForTin([2, 4, 10, 3, 5, 9, 4, 6, 8, 0], tinDigits)) {
                                return true;
                            }

                            return false;
                        },
                        needToValidate: function(tin) {
                            return u.consts('isEditTinEnabledInUserSettings') &&
                                this.get('tin_type') === 'legal' &&
                                tin.length !== 0;
                        },
                    },
                    controlNumberForPhysical: {
                        text: iget2('m-user-settings', 'control-number', 'Некорректный ИНН'),
                        validate: function(tin) {
                            var tinDigits = tin.split('').map(Number);

                            if (
                                tinDigits[10] === getControlNumberForTin([7, 2, 4, 10, 3, 5, 9, 4, 6, 8], tinDigits) &&
                                tinDigits[11] === getControlNumberForTin([3, 7, 2, 4, 10, 3, 5, 9, 4, 6, 8], tinDigits)
                            ) {
                                return true;
                            }

                            return false;
                        },
                        needToValidate: function(tin) {
                            return u.consts('isEditTinEnabledInUserSettings') &&
                                this.get('tin_type') === 'physical' &&
                                tin.length !== 0;
                        },
                    },
                }

            }
        },
        news: 'boolean',
        tags_allowed: 'boolean',
        warn: 'boolean',
        accnews: 'boolean',
        send_all_camp_letters: 'boolean',
        send_all_camp_sms: 'boolean',
        use_camp_description: 'boolean',
        can_use_day_budget: 'boolean',
        show_market_rating: 'boolean',
        email_lang: 'string',
        auto_video: 'boolean',
        videohints_enabled: 'boolean',
        is_pro_strategy_view_enabled: 'is_pro_strategy_view_enabled',
        metrika_counters: 'string'
    });
})();
