BEM.MODEL.decl('m-vcard', {
    // поля пришедшие с сервера
    cid: 'string',
    name: 'string',
    country_code: 'string',
    city_code: 'string',
    geoId: 'string',
    phone: 'string',
    ext: 'string',
    country: 'string',
    city: 'string',
    metro_name: 'string',
    metro: 'number',
    street: 'string',
    house: 'string',
    build: 'string',
    apart: 'string',
    //время работы в виде строки
    worktime: 'string',
    worktimes: 'array',
    contactperson: 'string',
    contact_email: 'string',
    im_client: 'string',
    im_login: 'string',
    vcard_id: 'string',
    extra_message: 'string',
    auto_point: 'string',
    auto_bounds: 'string',
    auto_precision: 'string',
    manual_point: 'string',
    manual_bounds: 'string',
    org_details_id: 'string',
    ogrn: 'string',

    // поля заполняемые исключительно на клиенте

    // поля, используемые только в мастере визиток

    // позиция визитки относительно других визиток
    position: {
        type: 'number',
        preprocess: function(val) {
            if (!val) return 0;

            return (+val);
        },
        precision: 0
    },
    // объект вида { Number total, Number active } с соотв. счетчиками баннеров, к которым привязана визитка
    bannersCount: {},
    // показатель привязки визитки только к архивным баннерам
    isArchived: {
        type: 'boolean',
        dependsFrom: ['bannersCount'],
        calculate: function() {
            var bannersCount = this.get('bannersCount');

            return bannersCount && !(bannersCount.total === 0 || bannersCount.active > 0);
        }
    },
    // цвет визитки, вычисляется из позиции (вариантов цвета от 1 до 12)
    color: {
        type: 'number',
        dependsFrom: ['position'],
        calculate: function() {
            return (this.get('position') - 1) % 12 + 1;
        }
    }

}, {

});
