BEM.DOM.decl({ block: 'outdoor-map-popup', implements: 'i-modal-popup-inner-block-interface' }, {

    onSetMod: {
        js: function() {
            this._renderDnaComponent();
        }
    },

    _saveButton: null,

    _isChangedValue: null,

    /**
     * Были ли изменения
     * @returns {$.Deferred<Boolean>}
     */
    isChanged: function() {
        var deferred = $.Deferred();

        deferred.resolve(!!this._isChangedValue);

        return deferred.promise();
    },

    /**
     * Преобразует данные из стейта компонента в серверные
     * @param {Object} data
     * @return {{selected: Array}}
     * @private
     */
    _provideData: function(data) {
        return data;
    },

    /**
     * Обработчик клика по любой кнопке внутри блока
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onButtonClick: function(e, data) {
        this.elem('save').is(e.block.domElem) && this._onSaveClick(e, data);
        this.elem('cancel').is(e.block.domElem) && this._onCancelClick(e, data);
    },

    /**
     * Обработчик клика по любой кнопке "Сохранить"
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onSaveClick: function(e, data) {
        this._saveButton || (this._saveButton = e.block);

        this.trigger('save', this._provideData(this._currentValue));
    },

    /**
     * Возвращает инстанс кнопки "Сохранить"
     * @private
     */
    _getSaveButton: function() {
        return this._saveButton || (this._saveButton = this.findBlockOn('save', 'button'));
    },

    /**
     * Возвращает инстанс прогнозатора
     * @private
     */
    _getPredictor: function() {
        return this._predictor = this.findBlockOn('predictor', 'b-outdoor-predictor');
    },

    /**
     * Обработчик клика по любой кнопке "Отмена"
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onCancelClick: function(e, data) {
        this.trigger('cancel');
    },

    /**
     * Возвращает все id щитов сгруппированых по регионам(id региона)
     * @returns {Object} id щитов по регионам
     * @private
     */
    _getAllPlatformsId: function() {
        return this.params.platformsByRegion.reduce(function(res, region) {
            res[region.regionId] = region.platforms.map(function(platform) {
                return platform.id;
            });

            return res;
        }, {});
    },

    /**
     * Возвращает всех операторов
     * @returns {Array} - operator names(String)
     * @private
     */
    _getAllOperators: function() {
        var platformsByRegion = this.params.platformsByRegion,
            result = [];

        Object.keys(platformsByRegion).map(function(regionId) {
            return platformsByRegion[regionId].platforms.map(function(platform) {
                result.push(platform.provider);
            });
        });

        return u._.uniq(result);
    },

    /**
     * Возвращает все форматы щитов
     * @returns {Array} - platform formats(String)
     * @private
     */
    _getAllFormats: function() {
        var platformsByRegion = this.params.platformsByRegion,
            result = [];

        Object.keys(platformsByRegion).map(function(regionId) {
            return platformsByRegion[regionId].platforms.map(function(platform) {
                result.push(platform.format);
            });
        });

        return u._.uniq(result);
    },

    _getRegionName: function(regionId) {
        var regionName = '';

        this.params.platformsByRegion.forEach(function(region) {
            if (region.regionId === regionId) {
                regionName = region.regionText;
            }
        });

        return regionName;
    },

    /**
     * Обработчик изменения в попапе
     * @param {Object} state
     * @param {Object} state.data
     * @param {Boolean} state.isTargetingActive
     * @private
     */
    _onSettingsChange: function(state) {
        this._isChangedValue = true;
        this._currentValue = state;

        var checkedByRegion = state.checkedByRegion,
            selectedRegion = state.selectedRegion,
            predictorResponseData = this._formatDataToResponse(checkedByRegion, selectedRegion),
            predictorSummary = this._formatDataForSummary(checkedByRegion),
            checkedByRegionIsEmpty = true;

        Object.keys(checkedByRegion).map(function(region) {
            if (checkedByRegion[region].length && checkedByRegionIsEmpty) {
                checkedByRegionIsEmpty = false;
            }
        });

        if (checkedByRegionIsEmpty) {
            predictorSummary = {
                operators: '—',
                formats: '—',
                regions: '—',
                platforms: []
            };
        }

        this._getPredictor().setRegion(this._getRegionName(selectedRegion));
        this._getPredictor().update(predictorResponseData, predictorSummary);

        var selectedPlatformsCount = 0,
            regions = this._currentValue.checkedByRegion;

        for (var regionId in regions) {
            selectedPlatformsCount += regions[regionId].length;
        }

        if (selectedPlatformsCount > 0) {
            this._getSaveButton().hasMod('disabled') ? this._getSaveButton().delMod('disabled') : undefined;
        } else {
            this._getSaveButton().setMod('disabled', 'yes');
        }
    },

    _formatDataForSummary: function(selectedByRegion) {
        var regions = this.params.platformsByRegion,
            allFormats, allOperators,
            selectedPlatformsId = [],
            regionsId = [],
            regionsName = [],
            operators = [],
            formats = [];

        Object.keys(selectedByRegion).map(function(regionId) {
            var regionPlatforms = selectedByRegion[regionId];

            if (regionPlatforms.length) {
                regionsId.push(regionId);
            }

            selectedPlatformsId = selectedPlatformsId.concat(regionPlatforms);
        });

        regions.map(function(region) {
            var items = region.platforms;

            if (regionsId.includes(region.regionId)) {
                regionsName.push(region.regionText);
            }

            items.forEach(function(item) {
                if (selectedPlatformsId.includes(item.id)) {
                    formats.push(item.format);
                    operators.push(item.provider);
                }
            })
        });

        operators = u._.uniq(operators);
        formats = u._.uniq(formats);

        allFormats = this._getAllFormats().filter(function(format) {
            return !formats.includes(format)
        });
        allOperators = this._getAllOperators().filter(function(operator) {
            return !operators.includes(operator)
        });

        if (!allFormats.length) {
            formats = [iget2('outdoor-map-popup', 'all', 'Все')];
        }

        if (!allOperators.length) {
            operators = [iget2('outdoor-map-popup', 'all', 'Все')];
        }

        return {
            operators: operators.join(', '),
            formats: formats.join(', '),
            regions: regionsName.join(', '),
            platforms: selectedPlatformsId
        };
    },

    _formatDataToResponse: function(platforms, selectedRegion) {
        var data = {
                campaign_id: this.params.campaign_id,
                page_blocks: [],
                page_blocks_region: []
            },
            params = this.params,
            allSelectedRegionPlatforms = [],
            groupId = params.adgroup_id,
            isNewGroup = params.isNewGroup,
            videoCreativeIds = params.video_creative_ids,
            pagesAndBlocksId = {};

        if (selectedRegion) {
            if (platforms[selectedRegion]) {
                platforms[selectedRegion].map(
                    function(val) {
                        var splitVal = val.split(':'),
                            blockId = splitVal[1],
                            pageId = splitVal[0];

                        pagesAndBlocksId[pageId] = (pagesAndBlocksId[pageId] || []);
                        pagesAndBlocksId[pageId].push(blockId);
                    }
                );
            }

            this._getAllPlatformsId()[selectedRegion].map(
                function(val) {
                    var splitVal = val.split(':'),
                        blockId = splitVal[1],
                        pageId = splitVal[0];

                    allSelectedRegionPlatforms[pageId] = (allSelectedRegionPlatforms[pageId] || []);
                    allSelectedRegionPlatforms[pageId].push(blockId);
                }
            );

            Object.keys(allSelectedRegionPlatforms).map(function(page) {
                data.page_blocks_region.push({
                    block_ids: allSelectedRegionPlatforms[page],
                    page_id: page
                })
            });
        } else {
            Object.keys(platforms).map(function(regionId) {
                platforms[regionId].map(
                    function(val) {
                        var splitVal = val.split(':'),
                            blockId = splitVal[1],
                            pageId = splitVal[0];

                        pagesAndBlocksId[pageId] = (pagesAndBlocksId[pageId] || []);
                        pagesAndBlocksId[pageId].push(blockId);
                    }
                );
            });
        }

        Object.keys(pagesAndBlocksId).map(function(page) {
            data.page_blocks.push({
                block_ids: pagesAndBlocksId[page],
                page_id: page
            })
        });

        if (!isNewGroup) {
            data.adgroup_id = groupId;
        }

        // TODO @ruzhansky - при создании группы, поле video_creative_ids инитится массив с элементом(пустая строка).
        if (videoCreativeIds && videoCreativeIds[0]) {
            data.video_creative_ids = videoCreativeIds;
        }

        return data;
    },

    /**
     * Render DNA component
     */
    _renderDnaComponent: function() {
        var dna = window.dna,
            selectedByRegion = this.params.selectedByRegion || {},
            platformsByRegion = this.params.platformsByRegion,
            selectedCount = 0,
            totalPlatformCount = 0,
            selectedRegion;

        u._.keys(selectedByRegion).forEach(function(regionId) {
            if (selectedByRegion[regionId].length > selectedCount) {
                selectedCount = selectedByRegion[regionId].length;
                selectedRegion = regionId;
            }
        });

        if (!selectedRegion) {
            platformsByRegion.forEach(function(region) {
                if (region.platforms.length > totalPlatformCount) {
                    totalPlatformCount = region.platforms.length;
                    selectedRegion = region.regionId;
                }
            })
        }

        dna.reactDOMRender(dna.reactCreateElement(
            dna.components.OutdoorMap, {
                onChange: this._onSettingsChange.bind(this),
                platformsByRegion: platformsByRegion,
                selectedRegion: selectedRegion,
                selectedByRegion: selectedByRegion,
                renderTitle: false
            }, null), this.elem('settings')[0]);

        // TODO - сформировать данные выбранных щитво при инициализации
        this._getPredictor().setRegion(this._getRegionName(selectedRegion));

        this._getPredictor().update(
            this._formatDataToResponse(selectedByRegion, selectedRegion),
            this._formatDataForSummary(selectedByRegion)
        );
    },

    destruct: function() {
        window.dna.reactDOMUnmount(this.elem('settings')[0]);
        BEM.DOM.destruct(this.domElem, true); // чистим внутренности

        return this.__base.apply(this, arguments);
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('click', 'button', function(e, data) {
                this._onButtonClick(e, data);
            });

        return false;
    }

});
