match(function() {
    return this.data.cmd === 'apiCertificationRequestsByDate' || this.data.cmd === 'apiCertificationSearchRequest';
})(

    block('app-main')(
        mode('preprocess')(function() {
            var data = this.data;

            data.items = this.data.requests.result;
            data.itemsPerPageVariants = {
                10: '10',
                30: '30',
                50: '50',
                100: '100',
                10000: '10000'
            };
            data.itemsPerPage = data.FORM.objects_on_page || 10;

            return data;
        }),

        mode('page-block')('p-admin-certification-request-list')
    ),

    block('b-page').mode('title')(function() {
        return iget2('p-admin-certification-request-list', 'spisok-zayavok-na-poluchenie', 'Список заявок на получение доступа к API');
    })
);

block('p-admin-certification-request-list')(
    addJs()(true),

    content()(function() {
        return {
            block: 'l-page',
            mods: {
                layout: '16-60-16'
            },
            content: [
                {
                    elem: 'row',
                    left: '&nbsp;',
                    right: '&nbsp;',
                    center: {
                        block: 'b-page-title',
                        title: iget2('p-admin-certification-request-list', 'spisok-zayavok-na-poluchenie', 'Список заявок на получение доступа к API')
                    },
                    rgap: true
                },
                {
                    elem: 'row',
                    left: '&nbsp;',
                    right: '&nbsp;',
                    center: {
                        block: 'p-admin-certification-request-list',
                        elem: 'actions'
                    },
                    rgap: true
                },
                {
                    elem: 'row',
                    left: '&nbsp;',
                    right: '&nbsp;',
                    center: {
                        block: 'p-admin-certification-request-list',
                        elem: 'list',
                        items: this.data.items
                    },
                    rgap: true
                },
                this.data.requests.pagination && (this.data.requests.pagination || {}).max_page > 1 && {
                    elem: 'row',
                    left: '&nbsp;',
                    right: '&nbsp;',
                    center: {
                        block: 'p-admin-certification-request-list',
                        elem: 'pagination'
                    },
                    rgap: true
                },
                {
                    elem: 'row',
                    left: '&nbsp;',
                    right: '&nbsp;',
                    center: {
                        block: 'p-admin-certification-request-list',
                        elem: 'report-links'
                    },
                    rgap: true
                }
            ]
        };
    }),

    elem('pagination').content()(function() {
        var data = this.data,
            pagination = data.requests.pagination,
            itemsPerPage = data.itemsPerPage,
            minimalPageSize = Object.keys(data.itemsPerPageVariants)[0];

        return [
            {
                block: 'b-pager',
                mix: [{
                    block: 'p-admin-certification-request-list',
                    elem: 'pager'
                }],
                currentPage: pagination.page,
                pageParam: 'page',
                startFrom: 1,
                totalCount: pagination.max_page * itemsPerPage,
                perpageCount: itemsPerPage,
                pageUrl: u.getUrl(data.cmd, u.getUrlParams(['page', 'cmd', 'uid_url'])),
                content: [
                    {
                        elem: 'title',
                        content: iget2('p-admin-certification-request-list', 'stranicy', 'Страницы')
                    },
                    {
                        elem: 'button-prev',
                        content: iget2('p-admin-certification-request-list', 'predydushchaya', 'предыдущая')
                    },
                    {
                        elem: 'button-next',
                        content: iget2('p-admin-certification-request-list', 'sleduyushchaya', 'следующая')
                    },
                    {
                        elem: 'pages',
                        showFirst: true,
                        showLast: true
                    }
                ]
            },
            (data.items.length > minimalPageSize || pagination.max_page > 1) && {
                block: 'b-perpage-selector',
                perPageParamName: 'objects_on_page',
                pages: this.data.itemsPerPageVariants,
                url: u.getUrl(data.cmd, u.getUrlParams(['cmd', 'objects_on_page', 'page', 'uid_url'])),
                onpage: data.FORM.objects_on_page,
                content: {
                    elem: 'text',
                    content: iget2(
                        'p-admin-certification-request-list',
                        'pokazyvat-pagesselector-zayavok-na',
                        'Показывать {pagesSelector} заявок на странице',
                        {
                            pagesSelector: {
                                elem: 'pages-selector'
                            }
                        }
                    )
                }
            }
        ];
    }),

    elem('list').content()(function() {
        return {
            block: 'b-api-management-cer-list',
            mods: {
                type: 'admin'
            },
            items: this.ctx.items
        };
    }),

    elem('actions').content()([
        {
            elem: 'period-selector'
        },
        {
            elem: 'search-form'
        }
    ]),

    elem('period-selector').content()(function() {
        return [
            {
                period: 'today',
                title: iget2('p-admin-certification-request-list', 'segodnya', 'Сегодня')
            },
            {
                period: 'week',
                title: iget2('p-admin-certification-request-list', 'nedelya', 'Неделя')
            },
            {
                period: 'month',
                title: iget2('p-admin-certification-request-list', 'mesyac', 'Месяц')
            }
        ]
            .map(function(link) {
                return {
                    block: 'link',
                    mix: [{
                        block: 'p-admin-certification-request-list',
                        elem: 'period-link',
                        elemMods: {
                            active: this.data.FORM.period === link.period ? 'yes' : ''
                        }
                    }],
                    url: u.getUrl('apiCertificationRequestsByDate', {
                        period: link.period,
                        objects_on_page: this.data.itemsPerPage
                    }),
                    content: link.title
                };
            }, this);
    }),

    elem('search-form').content()(function() {
        return [
            {
                tag: 'input',
                attrs: {
                    type: 'hidden',
                    name: 'cmd',
                    value: 'apiCertificationSearchRequest'
                }
            },
            this.data.FORM.objects_on_page && {
                tag: 'input',
                attrs: {
                    type: 'hidden',
                    name: 'objects_on_page',
                    value: this.data.FORM.objects_on_page
                }
            },
            {
                block: 'input',
                mix: [{
                    block: 'p-admin-certification-request-list',
                    elem: 'search'
                }],
                name: 'query_string',
                value: this.data.FORM.query_string || '',
                content: {
                    elem: 'control'
                }
            },
            {
                block: 'button',
                mods: {
                    theme: 'action'
                },
                type: 'submit',
                content: iget2('p-admin-certification-request-list', 'nayti', 'Найти')
            }
        ];
    }),

    elem('report-links').content()(function() {
        return [
            {
                elem: 'report-link',
                content: [
                    {
                        block: 'button',
                        mix: {
                            block: 'p-admin-certification-request-list',
                            elem: 'generate-report'
                        },
                        content: iget2('p-admin-certification-request-list', 'sozdat-otchet', 'Создать отчет')
                    },
                    {
                        block: 'spin',
                        js: true,
                        mods: {
                            progress: 'yes',
                            theme: 'gray-16'
                        },
                        mix: {
                            block: 'p-admin-certification-request-list',
                            elem: 'generate-report-spin'
                        }
                    }
                ]
            },
            {
                elem: 'report-link',
                content: {
                    block: 'button',
                    mix: {
                        block: 'p-admin-certification-request-list',
                        elem: 'download-report'
                    },
                    content: iget2('p-admin-certification-request-list', 'vygruzit-otchet', 'Выгрузить отчет')
                }
            }
        ];
    })
);
