match(function() {
    return this.data.cmd === 'adminPageAg';
})(

    block('app-main').mode('page-block')('p-agency-admin'),

    block('b-page').mode('title')(function() {
        return iget2('p-agency-admin', 'administrirovanie', 'Администрирование');
    })
);

block('p-agency-admin').content()(function() {
    var list = [];

    hasLoginRights('is_agency_chief', 'is_agency_main') && list.push({
        url: u.getUrl('showAgReps') + (this.data.uid_url || ''),
        text: iget2('p-agency-admin', 'predstaviteli-agentstva', 'Представители агентства')
    });

    var newLimRepSchema = this.data.features_enabled_for_client.new_lim_rep_schema == 1;
    var showAssignButton = hasLoginRights('is_agency_chief', 'is_agency_chief_lim_rep') || (hasLoginRights('is_agency_main') && newLimRepSchema);
    showAssignButton && list.push({
        url: u.getUrl('manageClientsOfAgency'),
        text: iget2('p-agency-admin', 'agency-representative--assign', 'Назначение клиентов представителям агентства')
    });

    hasLoginRights('AllowMassADVQ') && list.push({
        url: u.getUrl('allowMassADVQ'),
        text: iget2('p-agency-admin', 'uvelichit-limit-zaprosov-v', 'Увеличить лимит запросов в "подборе слов"')
    });

    return {
        block: 'l-page',
        mods: {
            layout: '60'
        },
        content: [
            {
                elem: 'row',
                center: {
                    block: 'b-page-title',
                    title: iget2('p-agency-admin', 'administrirovanie', 'Администрирование')
                }
            },
            {
                elem: 'row',
                center: [
                    {
                        block: 'p-agency-admin',
                        elem: 'links-list',
                        content: [
                            {
                                text: iget2('p-agency-admin', 'parametry-predstavitelya-agentstva', 'Параметры представителя агентства'),
                                cmd: 'modifyUser',
                                urlParams: {
                                    rcmd: 'adminPageAg'
                                }
                            },
                            {
                                text: iget2('p-agency-admin', 'vse-kampanii-moih-subklientov', 'Все кампании моих субклиентов'),
                                cmd: 'showSubClientCamps'
                            },
                            {
                                text: iget2('p-agency-admin', 'statistika-po-klientam-agentstva', 'Статистика по клиентам агентства'),
                                cmd: 'showCampStat',
                                urlParams: {
                                    stat_type: 'by_agency_clients'
                                },
                                uidURL: this.data.uid_url
                            },
                            !hasLoginRights('agency_disallow_money_transfer') &&
                                {
                                    text: iget2('p-agency-admin', 'perenos-sredstv', 'Перенос средств'),
                                    cmd: 'transferStepZero',
                                    uidUrl: this.data.uid_url
                                },
                            {
                                text: iget2('p-agency-admin', 'skopirovat-kampaniyu', 'Скопировать кампанию'),
                                cmd: 'copyCamp'
                            },
                            hasLoginRights('is_agency_chief') ?
                                {
                                    text: iget2('p-agency-admin', 'perevod-vseh-klientov-agentstva', 'Перевод всех клиентов агентства в валюту платежа'),
                                    cmd: 'massMoveToRealMoney',
                                    uidUrl: this.data.uid_url
                                } :
                                undefined
                        ].map(function(item) {
                            return item && {
                                block: 'p-agency-admin',
                                elem: 'links-list-item',
                                content: {
                                    block: 'link',
                                    url: u.getUrl(item.cmd, item.urlParams) + (item.uidUrl || ''),
                                    content: item.text
                                }
                            };
                        })
                    },
                    {
                        block: 'p-agency-admin',
                        elem: 'links-list',
                        content: {
                            block: 'p-agency-admin',
                            elem: 'links-list-item',
                            content: {
                                block: 'link',
                                url: u.getUrl('listWarnPlace', {
                                    sort: 'addtime',
                                    reverse: 1,
                                    ws_place: 0,
                                    ws_time: '1d',
                                    ws_cid: 0,
                                    ws_done: 0
                                }),
                                content: iget2('p-agency-admin', 'traffic-volume-changes-monitoring', 'Мониторинг изменений объёма трафика по фразам')
                            }
                        }
                    },
                    list.length > 0 && {
                        block: 'p-agency-admin',
                        elem: 'links-list',
                        content: list.map(function(item) {
                            return {
                                block: 'p-agency-admin',
                                elem: 'links-list-item',
                                content: {
                                    block: 'link',
                                    url: item.url,
                                    content: item.text
                                }
                            };
                        })
                    }
                ]
            }
        ]
    };
});
