match(function() {
    return this.data.cmd === 'showAgReps';
})(

    block('app-main').mode('page-block')('p-agency-representatives'),

    block('b-page').mode('title')(function() {
        return iget2('p-agency-representatives', 'zaregistrirovannye-predstaviteli-agentstva', 'Зарегистрированные представители агентства');
    })
);

block('p-agency-representatives')(

    addJs()(true),

    content()(function() {
        var data = this.data,
            pm = data.login_rights,
            allowManagement = hasLoginRights('is_agency_chief', 'super_control', 'is_teamleader',
                'is_superteamleader') && !hasLoginRights('is_agency_main', 'superreader_control'),
            newLimRepSchema = data.features_enabled_for_client.new_lim_rep_schema == 1,
            groupedReps,
            noTeamleadGroup,
            withTeamLeadGroupsKeys,
            vacantTeamleaders = [];

        if (newLimRepSchema) {
            groupedReps = u._.groupBy(data.lim_reps, function(i) { return i.lim_rep_group_id; });
            noTeamleadGroup = groupedReps[null] || [];
            withTeamLeadGroupsKeys = Object.keys(groupedReps).filter(function(key) {
                return key != 'null';
            });
            allowManagement = allowManagement || hasLoginRights('is_agency_main');
            vacantTeamleaders = data.lim_reps.filter(function(rep) {
                return rep.has_main_lim_reps_in_group === 0;
            });
        }

        return {
            block: 'l-page',
            mods: {
                layout: '16-80'
            },
            content: [
                {
                    elem: 'row',
                    left: true,
                    right: [
                        {
                            block: 'b-page-title',
                            mix: [{
                                block: 'p-agency-representatives',
                                elem: 'title'
                            }],
                            title: iget2('p-agency-representatives', 'zaregistrirovannye-predstaviteli-agentstva', 'Зарегистрированные представители агентства')
                        },
                        {
                            block: 'p-agency-representatives',
                            elem: 'warning',
                            content: [
                                {
                                    block: 'icon',
                                    mods: {
                                        'size-13': 'alert'
                                    },
                                    mix: [{
                                        block: 'p-agency-representatives',
                                        elem: 'warning-icon'
                                    }]
                                },
                                {
                                    block: 'link',
                                    target: '_blank',
                                    url: u.getCommonHelpUrl('/direct/campaigns/agency-representatives.xml'),
                                    content: iget2(
                                        'p-agency-representatives',
                                        'upravlenie-predstavitelyami-agentstv-pomoshch',
                                        'Управление представителями агентств: помощь'
                                    )
                                }
                            ]
                        }
                    ]
                },
                {
                    elem: 'row',
                    left: true,
                    right: [
                        {
                            block: 'tabs',
                            mods: {
                                control: 'menu',
                                theme: 'border-bottom',
                                layout: 'horiz',
                                size: 'm'
                            },
                            mix: [{
                                block: 'p-agency-representatives',
                                elem: 'tabs'
                            }],
                            js: true,
                            panes: 'tabs',
                            content: [
                                {
                                    elem: 'tab',
                                    elemMods: {
                                        active: 'yes'
                                    },
                                    content: {
                                        block: 'link',
                                        content: iget2('p-agency-representatives', 'deystvuyushchie-predstaviteli', 'Действующие представители')
                                    }
                                },
                                {
                                    elem: 'tab',
                                    content: {
                                        block: 'link',
                                        content: iget2('p-agency-representatives', 'udalennye-predstaviteli', 'Удаленные представители')
                                    }
                                }
                            ]
                        },
                        {
                            block: 'tabs-panes',
                            id: 'tabs',
                            content: [
                                {
                                    elem: 'pane',
                                    elemMods: {
                                        active: 'yes'
                                    },
                                    content: [
                                        {
                                            block: 'p-agency-representatives',
                                            elem: 'representatives-list',
                                            elemMods: {
                                                type: 'chief'
                                            },
                                            representatives: [data.chief_rep],
                                            title: iget2('p-agency-representatives', 'glavnyy-predstavitel', 'Главный представитель')
                                        },
                                        data.main_agency_reps && !!data.main_agency_reps.length && {
                                            block: 'p-agency-representatives',
                                            elem: 'representatives-list',
                                            elemMods: {
                                                type: 'main'
                                            },
                                            representatives: data.main_agency_reps,
                                            allowManagement: allowManagement,
                                            title: iget2('p-agency-representatives', 'predstaviteli', 'Представители')
                                        },
                                        !newLimRepSchema && data.limited_agency_reps &&
                                            !!data.limited_agency_reps.length && {
                                                block: 'p-agency-representatives',
                                                elem: 'representatives-list',
                                                elemMods: {
                                                    type: 'limited'
                                                },
                                                representatives: data.limited_agency_reps,
                                                allowManagement: allowManagement,
                                                title: iget2('p-agency-representatives', 'predstaviteli-po-rabote-s', 'Представители по работе с клиентами')
                                            },
                                        newLimRepSchema && data.lim_reps && data.lim_reps.length && [
                                            {
                                                block: 'p-agency-representatives',
                                                elem: 'representatives-list',
                                                elemMods: {
                                                    type: 'limited'
                                                },
                                                representatives: noTeamleadGroup,
                                                allowManagement: allowManagement,
                                                title: iget2('p-agency-representatives', 'predstaviteli-po-rabote-s', 'Представители по работе с клиентами')
                                            },
                                            withTeamLeadGroupsKeys.map(function(key) {
                                                var sortedReps = groupedReps[key].sort(function(a, b) { return a.lim_rep_type === 'chief' ? -1 : 1; }),
                                                    chief = sortedReps[0],
                                                    availableTeamleaders = vacantTeamleaders.filter(function(rep) {
                                                        return rep.login !== chief.login;
                                                    });

                                                return {
                                                    block: 'p-agency-representatives',
                                                    elem: 'representatives-list',
                                                    elemMods: {
                                                        type: 'limited'
                                                    },
                                                    representatives: groupedReps[key],
                                                    allowManagement: allowManagement,
                                                    title: [
                                                        iget2('p-agency-representatives', 'predstaviteli-po-rabote-s', 'Представители по работе с клиентами') +
                                                            ' (' + chief.login + ')',
                                                        !!availableTeamleaders.length && [
                                                            {
                                                                block: 'select2',
                                                                mix: {
                                                                    block: 'p-agency-representatives',
                                                                    elem: 'teamleader-change'
                                                                },
                                                                mods: {
                                                                    size: 's',
                                                                    theme: 'normal',
                                                                    type: 'radio'
                                                                },
                                                                val: availableTeamleaders[0].login,
                                                                items: availableTeamleaders.map(function(rep) {
                                                                    return {
                                                                        val: rep.login,
                                                                        text: rep.login
                                                                    };
                                                                })
                                                            },
                                                            {
                                                                block: 'button',
                                                                js: {
                                                                    repLogin: chief.login
                                                                },
                                                                mods: {
                                                                    size: 's'
                                                                },
                                                                mix: {
                                                                    block: 'p-agency-representatives',
                                                                    elem: 'teamleader-change-submit'
                                                                },
                                                                content: iget2('p-agency-representatives', 'change-teamledaer', 'Сменить тимлидера')
                                                            }
                                                        ]
                                                    ]
                                                };
                                            }),
                                        ],
                                        {
                                            block: 'p-agency-representatives',
                                            elem: 'toolbox',
                                            content: [
                                                (allowManagement || pm.manager_control) && {
                                                    elem: 'action',
                                                    content: {
                                                        block: 'link',
                                                        url: u.getUrl('addAgRep', {
                                                            ulogin: data.user_login
                                                        }),
                                                        content: iget2('p-agency-representatives', 'naznachit-novogo-predstavitelya', 'Назначить нового представителя')
                                                    }
                                                },
                                                data.main_agency_reps &&
                                                    !!data.main_agency_reps.length && allowManagement && !pm.is_agency_main && {
                                                        elem: 'action',
                                                        content: {
                                                            block: 'link',
                                                            url: u.getUrl('switchAgChief', {
                                                                ulogin: data.user_login
                                                            }),
                                                            content: iget2('p-agency-representatives', 'smenit-glavnogo-predstavitelya', 'Сменить "главного" представителя')
                                                        }
                                                    },
                                                data.limited_agency_reps && !!data.limited_agency_reps.length &&
                                                    allowManagement && !pm.manager_control && {

                                                        elem: 'action',
                                                        content: {
                                                            block: 'link',
                                                            url: u.getUrl('manageClientsOfAgency', {
                                                                ulogin: data.user_login
                                                            }),
                                                            content: iget2(
                                                                'p-agency-representatives',
                                                                'naznachenie-klientov-predstavitelyam-agentstva',
                                                                'Назначение клиентов представителям агентства'
                                                            )
                                                        }
                                                    }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    elem: 'pane',
                                    content: data.deleted_agency_reps && !!data.deleted_agency_reps.length ?
                                        {
                                            block: 'p-agency-representatives',
                                            elem: 'representatives-list',
                                            elemMods: {
                                                type: 'removed'
                                            },
                                            representatives: data.deleted_agency_reps,
                                            allowManagement: allowManagement
                                        } :
                                        iget2('p-agency-representatives', 'udalennyh-predstaviteley-net', 'Удаленных представителей нет')
                                }
                            ]
                        }
                    ]
                }
            ]
        };
    }),

    elem('representatives-list').content()(function() {
        var mods = this.ctx.elemMods,
            // таблица "главный представитель"
            isChief = mods && mods.type === 'chief',
            // таблица "представители по работе с клиентами
            isLimited = mods && mods.type === 'limited',
            // таблица "удаленные представители"
            isRemoved = mods && mods.type === 'removed',
            data = this.data,
            allowManagement = this.ctx.allowManagement,
            pm = data.login_rights,
            form = data.FORM,
            sortBy = (form.sort === 'fio' ? 'FIO' : form.sort) || 'login';

        return [
            this.ctx.title && {
                elem: 'list-title',
                content: this.ctx.title
            },
            {
                block: 'b-data-table',
                mods: {
                    sortable: isChief ? '' : 'server'
                },
                anchor: isRemoved && 'old',
                sortBy: sortBy,
                sortFunction: function(a, b) {
                    var val1 = typeof a[sortBy] === 'string' || a[sortBy] instanceof String ?
                        a[sortBy].toLowerCase() :
                        a[sortBy],

                        val2 = typeof b[sortBy] === 'string' || b[sortBy] instanceof String ?
                        b[sortBy].toLowerCase() :
                        b[sortBy];

                    if (val1 < val2) {
                        return -1;
                    } else if (val1 === val2) {
                        return 0;
                    } else {
                        return 1;
                    }
                },
                mix: [{
                    block: 'b-style-table',
                    mods: {
                        theme: 'gray-list'
                    }
                }],
                columns: [
                    {
                        key: 'num',
                        title: isChief ? '' : iget2('p-agency-representatives', 'no', '№'),
                        sortDisable: true,
                        transformData: function(row, num) {
                            return isChief ? '' : num;
                        }
                    },
                    {
                        key: 'login',
                        title: iget2('p-agency-representatives', 'login', 'Логин'),
                        transformData: function(row) {
                            return isLimited ?
                                {
                                    block: 'link',
                                    url: u.getUrl('showClients', {
                                        ulogin: row.login
                                    }),
                                    content: row.login
                                } :
                                row.login;
                        }
                    },
                    {
                        key: 'FIO',
                        title: iget2('p-agency-representatives', 'fio', 'ФИО'),
                        transformData: function(row) {
                            return (row.FIO || row.fio || '').toString();
                        }
                    },
                    {
                        key: 'email',
                        title: iget2('p-agency-representatives', 'e-mail', 'E-mail'),
                        transformData: function(row) {

                            return {
                                block: 'link',
                                url: 'mailto:' + row.email,
                                content: row.email
                            };
                        }
                    },
                    !isRemoved && {
                        key: 'phone',
                        title: iget2('p-agency-representatives', 'telefon', 'Телефон'),
                        transformData: function(row) {
                            return (row.phone || '').toString();
                        }
                    },
                    !pm.superreader_control && {
                        key: 'actions',
                        transformData: function(row) {
                            var modifyAction = {
                                block: 'p-agency-representatives',
                                elem: 'action',
                                content: {
                                    block: 'link',
                                    url: u.getUrl('modifyUser', {
                                        ulogin: row.login,
                                        rcmd: 'showAgReps',
                                        rulogin: form.ulogin || ''
                                    }),
                                    content: iget2('p-agency-representatives', 'redaktirovat', 'редактировать')
                                }
                            };

                            if (isRemoved) {

                                return (row.is_free_for_rep && allowManagement || pm.manager_control) && {
                                    block: 'p-agency-representatives',
                                    elem: 'action',
                                    content: {
                                        block: 'link',
                                        url: u.getUrl('addAgRep', {
                                            ag_login: row.login,
                                            ag_name: row.fio && row.fio.toString(),
                                            ag_email: row.email && row.email.toString(),
                                            ag_phone: row.phone && row.phone.toString(),
                                            use_deleted: 1,
                                            rcmd: 'showAgReps',
                                            ulogin: form.ulogin && !pm.is_any_client ? form.ulogin : '',
                                            rulogin: form.ulogin || ''
                                        }),
                                        content: iget2('p-agency-representatives', 'vosstanovit', 'восстановить')
                                    }
                                };
                            } else if (isChief) {

                                return !pm.is_agency_main && modifyAction;
                            } else {
                                var result = [];

                                (!row.is_chief || !pm.agency_control) && result.push(modifyAction);

                                !row.is_chief && allowManagement && result.push({
                                    block: 'p-agency-representatives',
                                    elem: 'action',
                                    content: {
                                        block: 'link',
                                        mods: {
                                            'need-confirm': 'yes'
                                        },
                                        confirm: iget2(
                                            'p-agency-representatives',
                                            'posle-udaleniya-etot-polzovatel',
                                            'После удаления этот пользователь потеряет возможность управления всеми рекламными кампаниями, которые размещаются во всех коммерческих сервисах Яндекса под вашим логином.'
                                        ) +
                                            '<br />' + iget2('p-agency-representatives', 'vy-deystvitelno-hotite-udalit', 'Вы действительно хотите удалить этого представителя?'),
                                        url: u.getUrl('deleteAgRep', {
                                            ulogin: row.login
                                        }),
                                        content: iget2('p-agency-representatives', 'udalit', 'удалить')
                                    }
                                });

                                return result;
                            }
                        }
                    }
                ],
                rows: this.ctx.representatives || [],
                mixes: {
                    row: [{
                        block: 'b-style-table',
                        elem: 'row'
                    }],
                    headerRow: [{
                        block: 'b-style-table',
                        elem: 'head'
                    }],
                    cell: function(key) {
                        return [
                            {
                                block: 'b-style-table',
                                elem: 'cell'
                            },
                            {
                                block: 'p-agency-representatives',
                                elem: key + '-cell'
                            }
                        ];
                    },
                    headerCell: [{
                        block: 'b-style-table',
                        elem: 'cell'
                    }]
                }
            }
        ];
    })
);
