BEM.DOM.decl('p-agency-representatives', {

    onSetMod: {

        js: function() {
            u.graspSelf.call(this, {
                tabs: 'tabs inside'
            });

            if (window.location.hash === '#old') {
                this.tabs.activate(1);
            }

            this.tabs.on('change', function(e, data) {
                window.location.hash = data.currentIndex ? 'old' : 'new';
            });
        }

    },

    _onChangeTeamleaderkClick: function(repLogin, newRepLogin) {

        BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            cache: false,
            dataType: 'json',
            type: 'POST',
            callbackCtx: this
        }).get(
            {
                cmd: 'ajaxSwapAgLimRepChiefs',
                swap_rep_login: repLogin,
                solo_rep_login: newRepLogin
            },
            function() {
                window.location.reload();
            },
            function() {
                alert(iget2('p-agency-representatives', 'error', 'Произошла ошибка, обновите страницу и попробуйте еще раз.'));
            }
        );
    }

}, {
    live: function() {
        this
            .liveInitOnBlockInsideEvent('click', 'button', function(e) {
                var domElem = e.block.domElem,
                    select,
                    repLogin,
                    newRepLogin;

                if (!this.findElem(domElem, 'teamleader-change-submit').length) {
                    return;
                }

                select = this.findBlockInside(domElem.parent(), 'select2');
                repLogin = e.block.params.repLogin;
                newRepLogin = select.getVal();

                this._onChangeTeamleaderkClick(repLogin, newRepLogin);
            });

        return true;
    }
});
