match(function() {
    return this.data.cmd === 'ajaxBindingPaymentError';
})(

    block('app-main').mode('page-block')('p-ajax-payment-error'),

    block('b-page')(

        mode('content-only')(true),

        mode('title')(function() {
            return iget2('p-ajax-payment-error', 'oshibka-privyazki-karty', 'Ошибка привязки карты');
        })
    )

);

block('p-ajax-payment-error')(

    addJs()(true),

    content()(function() {
        return [
            {
                block: 'b-page-title',
                mods: {
                    size: 's'
                },
                mix: {
                    block: 'p-ajax-payment-error',
                    elem: 'error-header'
                },
                elem: 'title',
                content: iget2('p-ajax-payment-error', 'nelzya-privyazat-kartu', 'Нельзя привязать карту')
            },
            {
                elem: 'error-details',
                content: u.spacer2([
                    this.data.error ? this.xmlEscape(this.data.error) : '',
                    this.data.error_code === 'TOO_MANY_CARDS' && iget2(
                        'p-ajax-payment-error',
                        'too-many-cards',
                        'Пожалуйста, отвяжите одну из карт в {profile} и повторите привязку.',
                        {
                            profile: applyCtx({
                                block: 'link',
                                url: u.formatUrl({ protocol: 'https', host: this.data.passport_domain }),
                                target: '_top',
                                content: iget2('p-ajax-payment-error', 'profile', 'профиле')
                            })
                        }
                    )
                ], ' ')
            }
        ];
    })
);
