block('p-api-certification-request-edit').elem('checkbox-group')(

    js()(true),

    content()(function() {
        var values = this.ctx.value,
            name = this.ctx.name,
            inputName = this.ctx.inputName,
            inputValue = this.ctx.inputValue || '',
            errorMessage = this.ctx.errorMessage,
            hint = this.ctx.inputHint;

        return this.ctx.options.map(function(item) {
            return {
                block: 'checkbox',
                mix: {
                    block: 'p-api-certification-request-edit',
                    elem: item.value == 'other' ? 'other-field-option' : 'block-view-control'
                },
                mods: { checked: values && values.indexOf(item.value) >= 0 ? 'yes' : '' },
                checkboxAttrs: {
                    value: item.value,
                    name: name
                },
                text: item.title
            };
        }).concat([
            {
                block: 'input',
                name: inputName,
                value: inputValue || '',
                mix: [
                    {
                        block: 'p-api-certification-request-edit',
                        elem: 'other-' + u.beminize(name)
                    },
                    {
                        block: 'p-api-certification-request-edit',
                        elem: 'other-option-input',
                        elemMods: { hidden: 'yes' }
                    }
                ],
                mods: { clear: 'no' },
                placeholder: hint,
                content: [
                    {
                        elem: 'control',
                        mix: {
                            block: 'p-api-certification-request-edit',
                            elem: 'mark-control'
                        }
                    }
                ]
            },
            errorMessage && {
                block: 'p-api-certification-request-edit',
                elem: 'error-message',
                elemMods: {
                    type: 'error',
                    visibility: 'visible'
                },
                content: errorMessage
            }
        ]);
    })
);
