BEM.DOM.decl({ block: 'p-api-certification-request-edit', elem: 'field', modName: 'name', modVal: 'app-files' }, {
    onSetMod: {
        js: function() {
            this.fileAttachElem = this.elemInstance('file-attachment');
            this.filesListElem = this.elemInstance('files-list');

            this.fileAttachElem &&
                this.fileAttachElem.on('form:removed form:added', this.updateRemoveBtnVisibility, this);
            this.filesListElem && this.filesListElem.on('file:deleted', this.toggleRequiredForm, this)
        }
    },

    /**
     * Добавляет форму для загрузки файла.
     * Срабатывает при удалении приложенного файла.
     * Если файлов в заявке не осталось - будет добавлена форма
     * @param {Object} e событие
     * @param {Number} filesNum кол-во файлов в списке
     * @returns {BEM}
     */
    toggleRequiredForm: function(e, filesNum) {
        !filesNum && this.fileAttachElem.addAttachForm()
    },

    /**
     * Устанавливает или снимает модификатор hidden с кнопки удаления первой формы
     * Если форма в режиме редактирования - кнопка будет скрыта если нет загруженных файлов и форма на странице одна
     * Если форма в режиме создания заявки - кнопка удаления будет скрыта у первой и единственной формы
     * @returns {BEM}
     */
    updateRemoveBtnVisibility: function() {
        var removeAttachFormElems = this.findElem('remove-attach-form'),
            isOnlyForm = removeAttachFormElems.length < 2;

        this.setMod(
            this.findElem('remove-attach-form').eq(0),
            'hidden',
            this.params.isEdit ?
                !this.findElem('files-list-item').length && isOnlyForm ? 'yes' : '' :
                isOnlyForm ? 'yes' : '');

        return this;
    },

    /**
     * Переопределенный метод validate.
     * Возвращает true если все поля описание файлов (input) заполнены и все блоки загрузки файлов заполнены, иначе false
     * @returns {Boolean}
     */
    validate: function() {
        var isAttaches = this.findBlocksInside('attach').every(function(attach) {
                return !!attach.val();
            }),
            isInputs = this.findBlocksInside('input').every(function(input) {
                return !!input.val();
            });

        return isAttaches && isInputs;
    }
});
