BEM.DOM.decl({ block: 'p-api-certification-request-edit', elem: 'field', modName: 'name', modVal: 'app-id' }, {
    onSetMod: {
        js: function() {

            this.select = this.findBlockOn('application-id-select', 'select');

            this.input = this.findBlockOn('application-id-input', 'input');

            this.request = BEM.create('i-request_type_ajax', {
                url: 'main.pl?cmd=ajaxApiCertificationValidateId',
                cache: false,
                dataType: 'json'
            });

            this.input.on('blur', function(e) {
                this.checkField('application-id-input', e.block);
            }, this);

            this.on('onValidation', function(e, isValid) {
                if (!isValid && !this.input.val()) {
                    this.addErrorLabel('application-id-input', iget2('p-api-certification-request-edit', 'ukazhite-application-id', 'Укажите application ID'))
                }
            }, this);

            // если у клиента нет ни одного id - select не будет показываться
            if (this.select) {
                this.select.on('change', function(e) {
                    this.checkField('application-id-select', e.block)
                        .toggleInput(!!e.block.val());
                }, this);

                this.toggleInput(!!this.select.val());
                this.checkField('application-id-select', this.select);
            }
        }
    },

    /**
     * Добавляет текст-сообщение типа type в элементе 'status-message' на элементе elem
     * @param {Jquery} elem элемент родитель
     * @param {String} text текст ошибки
     * @param {Boolean} isError флаг - отобразить текст как ошибку
     * @private
     */
    _addLabel: function(elem, text, isError) {
        BEM.DOM.update(
            this.findElem(elem, 'status-message'),
            $(BEMHTML.apply({
                block: 'input',
                elem: 'message',
                content: text,
                elemMods: {
                    type: isError ? 'error' : '',
                    visibility: 'visible'
                }
            })));
    },

    /**
     * Добавляет строку-сообщение в элементе 'status-message' на элементе elem
     * @param {Jquery} elem элемент родитель
     * @param {String} text текст ошибки
     * @returns {BEM}
     */
    addNoticeLabel: function(elem, text) {
        this._addLabel(elem, text, false);

        return this;
    },

    /**
     * Добавляет строку-ошибку в элементе 'status-message' на элементе elem
     * @param {Jquery} elem элемент родитель
     * @param {String} text текст ошибки
     * @returns {BEM}
     */
    addErrorLabel: function(elem, text) {
        this._addLabel(elem, text, true);

        return this;
    },

    /**
     * Очищает 'status-message' на элементе elem
     * @param {Jquery} elem элемент родитель
     * @returns {BEM}
     */
    clearLabel: function(elem) {
        BEM.DOM.update(this.findElem(elem, 'status-message'), '');

        return this;
    },

    /**
     * Проверяет аяксом указанный ID.
     * На время проверки блокирует контрол и выводит сообщение о проверке
     * @param {String} wrapElemName имя элемента в котором находится контрол
     * @param {BEM} control блок контрола
     * @returns {BEM}
     */
    checkField: function(wrapElemName, control) {

        var id = control.val();

        this.toggleElemErrorMod(wrapElemName, false);

        if (id) {
            this.addNoticeLabel(wrapElemName, iget2('p-api-certification-request-edit', 'proveryaem-id', 'проверяем ID'))
                .setFieldDisable(control, true)
                .sendAppIdAjaxRequest(u.escapeHTML(id), control, wrapElemName);
        }

        return this;
    },

    /**
     * Устанавливает модификатор disabled на блок контрола в зависимости со значением флага isDisable.
     * @param {BEM} field блок контрола
     * @param {Boolean} isDisable флаг
     * @returns {BEM}
     */
    setFieldDisable: function(field, isDisable) {
        field.setMod('disabled', isDisable ? 'yes' : '');

        return this;
    },

    /**
     * Устанавливает модификатор valid на элементе и error на элементе с именем.
     * @param {String} elem имя элемента-родителя контрола
     * @param {Boolean} isError флаг
     * @returns {BEM}
     */
    toggleElemErrorMod: function(elem, isError) {
        this.updateValidMod(!isError)
            .setMod(this.elem(elem), 'error', isError ? 'yes' : '');

        return this;
    },

    /**
     * Делает AJAX запрос на проверку ID.
     * По результатам проверки вызывает методы актуализации внешнего вида контрола и
     * текстового сообщения в элементе wrapElemName
     * @param {String} id строка с ID
     * @param {BEM} control блок контрола
     * @param {String} wrapElemName имя элемента в котором находится контрол
     */
    sendAppIdAjaxRequest: function(id, control, wrapElemName) {
        this.request.get({ application_id: id }, function(data) {
            var isError = data && !!data.errors.length,
                errorText = isError ? data.errors[0][1] : '';

            isError ?
                this.addErrorLabel(wrapElemName, errorText) :
                this.clearLabel(wrapElemName);

            this.setFieldDisable(control, false)
                .toggleElemErrorMod(wrapElemName, isError)
        }.bind(this));
    },
    /**
     * Обновляет атрибут name контролов select и input и внешний вид родительских элементов в зависимости от флага toggle.
     * если !toggle задаем имя application_id на input иначе на select
     * @param {Boolean} toggle флаг
     */
    toggleInput: function(toggle) {
        this.resetValidStatus()
            .updateValidMod(true)
            .resetControlStatus('application-id-select')
            .setMod(this.elem('application-id-input'), 'hidden', toggle ? 'yes' : '')
            .input.domElem.find('input')
            .attr('name', !toggle ? 'application_id' : '');

        this.select.domElem.find('select')
            .attr('name', toggle ? 'application_id' : '');

    },

    /**
     * Сбрасывает модификатор valid
     * @returns {BEM}
     */
    resetValidStatus: function() {
        this.updateValidMod(false);

        return this;
    },

    /**
     * Сбрасывает модификатор error c элемента wrapElemName
     * Сбрасывает сообщение-статус с элемента 'status-message' внутри элемента wrapElemName
     * @param {String} wrapElemName имя элемента в котором находится контрол
     * @returns {BEM}
     */
    resetControlStatus: function(wrapElemName) {
        this.clearLabel(wrapElemName)
            .delMod(this.elem(wrapElemName), 'error');

        return this;
    },

    /**
     * Переопределенный метод validate.
     * Если инпут скрыт - вернет true если в селекте указан ID и этот ID прошел AJAX проверку, иначе false.
     * Если инпут виден - вернет true если в inpute указан ID и этот ID прошел AJAX проверку, иначе false..
     * @returns {Boolean}
     */
    validate: function() {
        return this.hasMod(this.elem('application-id-input'), 'hidden', 'yes') ?
            this.select.val() && !this.hasMod(this.elem('application-id-select'), 'error', 'yes') :
            this.input.val() && !this.hasMod(this.elem('application-id-input'), 'error', 'yes')
    }
});
