block('p-api-certification-request-edit').elem('field').elemMod('name', 'technical-data').content()(function() {
    return [
        {
            block: 'p-api-certification-request-edit',
            elem: 'field-title',
            title: iget2('p-api-certification-request-edit', 'tehnicheskie-dannye-o-prilozhenii', 'Технические данные о приложении')
        },
        {
            elem: 'fields',
            fieldsArray: [
                {
                    block: 'input',
                    name: 'prog_language',
                    value: this.ctx.programLangValue,
                    mix: {
                        block: 'p-api-certification-request-edit',
                        elem: 'prog-language-input'
                    },
                    mods: { clear: 'no' },
                    content: [
                        {
                            elem: 'label',
                            mix: {
                                block: 'p-api-certification-request-edit',
                                elem: 'label'
                            },
                            content: [
                                iget2('p-api-certification-request-edit', 'yazyk-programmirovaniya', 'Язык программирования'),
                                {
                                    block: 'b-mark-required'
                                }
                            ]
                        },
                        {
                            elem: 'control',
                            mix: {
                                block: 'p-api-certification-request-edit',
                                elem: 'mark-control'
                            }
                        },
                        {
                            block: 'p-api-certification-request-edit',
                            elem: 'error-message',
                            elemMods: {
                                type: 'error',
                                visibility: 'visible'
                            },
                            content: iget2('p-api-certification-request-edit', 'ukazhite-yazyk-programmirovaniya', 'Укажите язык программирования')
                        }
                    ]
                },
                [
                    {
                        elem: 'label',
                        content: iget2('p-api-certification-request-edit', 'protokol', 'Протокол')
                    },
                    ['json', 'soap'].map(function(item) {
                        var isChecked = this.ctx.protocolValues && this.ctx.protocolValues.indexOf(item) >= 0;

                        return {
                            block: 'checkbox',
                            mix: {
                                block: 'p-api-certification-request-edit',
                                elem: 'inline-checkbox'
                            },
                            mods: { checked: isChecked ? 'yes' : '' },
                            checkboxAttrs: {
                                value: item,
                                name: 'protocol'
                            },
                            text: item.toUpperCase()
                        };
                    }, this)
                ],
                {
                    block: 'input',
                    name: 'library_version',
                    value: this.ctx.libraryVersionValue,
                    mods: { clear: 'no' },
                    content: [
                        {
                            elem: 'label',
                            mix: {
                                block: 'p-api-certification-request-edit',
                                elem: 'label'
                            },
                            content: iget2('p-api-certification-request-edit', 'versiya-bibliotek', 'Версия библиотек')
                        },
                        {
                            elem: 'control'
                        }
                    ]
                }
            ]
        }
    ];
});
