BEM.DOM.decl({ block: 'p-api-certification-request-edit', elem: 'field' }, {
    /**
     * Обновляет модификатор valid элемента.
     * @param {Boolean} isValid флаг состояния
     * @returns {BEM}
     */
    updateValidMod: function(isValid) {
        this.setMod(this.domElem, 'valid', !isValid ? 'no' : '');

        return this;
    },

    /**
     * Возвращает логическое значение корректности формы.
     * Метод переопределяется в модифицированных элементах.
     * @returns {Boolean}
     */
    validate: function() {
        return true;
    },

    /**
     * Запускает метод validate и метод обновления updateValidMod с результатом выполнения первого
     * также триггерит событие onValidation с результатом проверки
     * @returns {Boolean}
     */
    runValidation: function() {

        var isValid = this.validate();

        this.updateValidMod(isValid)
            .trigger('onValidation', isValid);

        return isValid;
    }
});
