BEM.DOM.decl({ block: 'p-api-certification-request-edit', elem: 'file-attachment' }, {
    onSetMod: {
        js: function() {
            this.bindTo('add-attach-form', 'click', this.addAttachForm);

            this.on('form:removed', this.refreshAttachIndexes, this)
        }
    },

    /**
     * Добавляет форму для загрузки файла
     * Триггерит событие form:added по завершению
     */
    addAttachForm: function() {
        BEM.DOM.before(
            this.elem('add-attach-form'),
            $(BEMHTML.apply({
                block: 'p-api-certification-request-edit',
                elem: 'file-attachment',
                index: this.findElem('file-attach').length,
                hideAddMoreBtn: true,
                showAttachForm: true
            })).slideDown('fast'));

        this.trigger('form:added');
    },

    /**
     * Удаляет форму по порядковому индексу index
     * @param {Number} index порядковый номер
     * Триггерит событие form:removed по завершению
     */
    removeAttachFormByIndex: function(index) {
        var _this = this;

        this.findElem('file-attach')
            .eq(index)
            .slideUp('fast', function(form) {
                BEM.DOM.destruct($(this));
                _this.trigger('form:removed')
            });
    },

    /**
     * Обновляет атрибут name у элемента index-field и контрола блока attach
     */
    refreshAttachIndexes: function() {
        var _this = this,
            elem;

        this.findElem('file-attach').each(function(index) {
            _this
                .findBlockInside($(this), 'attach').elem('control')
                .add(_this.findElem($(this), 'index-field'))
                .each(function() {
                    elem = $(this);

                    elem.attr({ name: elem.attr('name').replace(/[\d+]/, index) });
                });
        });
    }
}, {
    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button', function(e) {
            if (this.findElem(e.block.domElem, 'remove-attach-form').length) {
                this.removeAttachFormByIndex(this.findElem('remove-attach-form').index(e.block.domElem));
            }
        }, this);
    }
});
