block('p-api-certification-request-edit')(
    elem('files-list-item')(
        tag()('li'),

        content()(function() {

            var appId = this.ctx.appId,
                name = this.ctx.name,
                desc = u.hellipCut(this.ctx.desc, 200),
                isPicture = name.toLowerCase().match('\.(jpg|png|gif|jpeg|bmp)$');

            return [
                isPicture && {
                    elem: 'files-list-item-preview',
                    tag: 'img',
                    attrs: {
                        src: u.getUrl('apiCertificationGetFile', {
                            name: name,
                            application_id: appId
                        }),
                        title: iget2('p-api-certification-request-edit', 'udalit-fayl', 'Удалить файл')
                    }
                },
                {
                    elem: 'files-list-item-remove',
                    js: {
                        appId: appId,
                        fileName: name
                    },
                    content: '&times;'
                },
                {
                    elem: 'files-list-item-text',
                    content: [
                        {
                            elem: 'files-list-item-link',
                            content: {
                                block: 'link',
                                content: name,
                                url: u.getUrl('apiCertificationGetFile', {
                                    name: name,
                                    application_id: appId
                                })
                            }
                        },
                        {
                            elem: 'files-list-item-desc',
                            content: desc,
                            attrs: { title: this.ctx.desc }
                        }
                    ]
                },
                { elem: 'clear' }
            ];
        })
    ),

    elem('files-list')(

        js()(true),

        tag()('ul'),

        content()(function() {
            return this.ctx.files.map(function(file) {
                return {
                    elem: 'files-list-item',
                    appId: this.ctx.appId,
                    name: u.escapeHTML(file.name),
                    desc: u.escapeHTML(file.description)
                };
            }, this);
        })
    )
);
