BEM.DOM.decl({ block: 'p-api-certification-request-edit', elem: 'files-list' }, {
    onSetMod: {
        js: function() {

            this.request = BEM.create('i-request_type_ajax', {
                url: 'main.pl?cmd=ajaxApiCertificationDeleteFile',
                cache: false,
                dataType: 'json'
            });

            this.bindTo('files-list-item-remove', 'click', function(e) {
                this.deleteFile(
                    this.findElem('files-list-item-remove').index(e.data.domElem),
                    this.elemInstance(e.data.domElem).params)
            });
        }
    },

    /**
     * Удаляет DOM элемент node
     * @param {JQuery} node DOM элемент формы
     */
    removeFormNode: function(node) {
        node.slideUp('fast', function() {
            BEM.DOM.destruct(node);
            this.trigger('file:deleted', this.findElem('files-list-item').length);
        }.bind(this));
    },

    /**
     * Отправляет AJAX запрос на удаление файла после подтверждения в confirm.
     * По завершению вызывает метод removeFormNode для удаления DOM элемента
     * @param {Number} index порядковый номер файла
     * @param {Object} params хеш с данными для запроса (fileName - имя файла и appId - ID приложения)
     */
    deleteFile: function(index, params) {
        confirm(iget2('p-api-certification-request-edit', 'udalit-s-fayl-budet', 'Удалить {foo} ? Файл будет удален безвозвратно.', {
            foo: params.fileName
        })) && this.request.get({
            name: params.fileName,
            application_id: params.appId
        }, function() {
            this.removeFormNode(this.findElem('files-list-item').eq(index))
        }.bind(this));
    }
});
