BEM.DOM.decl({ block: 'p-api-certification-request-edit', elem: 'form' }, {

    onSetMod: {
        js: function() {

            this.setRequiredFields();

            this.params.isAddMode && this.addCommonRequiredFields();

            this.isChanged = false;

            BEM.blocks['i-unload-warning'].addChecker(this.getIsChangedFlag, this);

            this.buildRequiredFields();

            this.bindTo('form-footer-button', 'click', this.validateForm);
        }
    },

    /**
     * Возвращает флаг this.isChanged, сообщающий о том что в форме произошли изменения
     * @returns {Boolean}
     */
    getIsChangedFlag: function() {

        return this.isChanged;
    },

    /**
     * Устанавливает флаг this.isChanged, сообщающий о том что в форме произошли изменения
     * @param {Boolean} flag логическое значение
     * @returns {Boolean}
     */
    setChangedFlag: function(flag) {
        this.isChanged = flag;
    },

    /**
     * Задает массив с именами полей формы которые необходимо проверить при отправке формы.
     * Метод переопределяется в модифицированных элементах
     */
    setRequiredFields: function() {
        this.requiredFieldsNames = [];
    },

    /**
     * Добавляет в массив с именами полей формы которые необходимо проверить при отправке формы имена общих полей.
     * Метод переопределяется в модифицированных элементах
     */
    addCommonRequiredFields: function() {
        this.requiredFieldsNames.push('app-id', 'accept');
    },

    /**
     * Формирует массив Jquery объектов на основе массива имен полей.
     */
    buildRequiredFields: function() {
        this.requiredFields = this.requiredFieldsNames.map(function(name) {
            return this.elem('field', 'name', name);
        }, this);
    },

    /**
     * Выполняет проверку полей.
     * Если ошибок в форме нет - оправляет запрос
     */
    validateForm: function(e) {
        e.preventDefault();

        this.setChangedFlag(false);

        !this.requiredFields.filter(function(name) {

            return !this.elemInstance(name).runValidation();
        }.bind(this)).length ?
            this.domElem.submit() :
            BEM.blocks['b-confirm'].alert(iget2('p-api-certification-request-edit', 'ne-vse-polya-zapolneny', 'Не все поля заполнены корректно'));
    }
}, {
    live: function() {
        ['input', 'radiobox', 'checkbox'].forEach(function(control) {
            this.liveInitOnBlockInsideEvent('change', control, function(e) {
                /*
                * небольшой хак для инпута календаря
                * поскольку значение инпута устанавливается скриптом
                * срабатывает change инпута, хотя на самом мы ничего не меняли
                * поправим чтобы хендлер срабатывает если инпут изменен в фокусе
                * как это происходит при пользовательской правке
                */
                if (e.block.hasMod('has-calendar', 'yes')) {
                    e.block.hasMod('focused', 'yes') && this.setChangedFlag(true);
                } else {
                    this.setChangedFlag(true);
                }
            }, this);
        }, this);

        return false;
    }
});
