block('p-api-certification-request-edit').elem('header').elemMod('type', 'test').content()(function() {
    return [
        {
            elem: 'header-title',
            content: iget2(
                'p-api-certification-request-edit',
                'zayavka-na-poluchenie-dostupa',
                'Заявка на получение доступа к тестовой среде API Яндекс.Директ'
            )
        },
        {
            elem: 'header-links',
            links: [
                {
                    text: iget2('p-api-certification-request-edit', 'oformit-zayavku-na-polnyy', 'Оформить заявку на полный доступ'),
                    url: u.formatUrl({
                        path: 'registered/main.pl',
                        query: this.ctx.isEdit ?
                            {
                                cmd: 'apiCertificationUpgradeRequest',
                                access_type: 'normal',
                                application_id: this.data.request.application_id
                            } :
                            {
                                cmd: 'apiCertificationAddRequest',
                                access_type: 'normal'
                            }
                    })
                },
                !this.ctx.isEdit && {
                    text: iget2('p-api-certification-request-edit', 'registraciya-novogo-application-id', 'Регистрация нового application ID'),
                    target: '_blank',
                    url: u.formatUrl({
                        protocol: 'https',
                        host: 'oauth.yandex.' + (this.data.lang.match(/ru|ua/) ? 'ru' : 'com'),
                        path: '/client/new'
                    })
                }
            ]
        },
        this.ctx.isEdit && {
            elem: 'header-subtitle',
            appName: this.data.request.name,
            appId: this.data.request.application_id
        }
    ];
});
