block('p-api-certification-request-edit').elem('radio-group')(

    js()(true),

    content()(function() {
        var value = this.ctx.value,
            name = this.ctx.name,
            inputName = this.ctx.inputName,
            inputValue = this.ctx.inputValue || '',
            errorMessage = this.ctx.errorMessage,
            hint = this.ctx.inputHint;

        return {
            block: 'radiobox',
            value: value || '',
            name: name,
            content: this.ctx.options.map(function(item) {
                return {
                    elem: 'radio',
                    mix: {
                        block: 'p-api-certification-request-edit',
                        elem: item.value == 'other' ? 'other-field-option' : 'block-view-control'
                    },
                    controlAttrs: { value: item.value },
                    content: item.title
                }
            }).concat([
                {
                    block: 'input',
                    name: inputName,
                    value: inputValue || '',
                    mix: [
                        {
                            block: 'p-api-certification-request-edit',
                            elem: 'other-' + u.beminize(name)
                        },
                        {
                            block: 'p-api-certification-request-edit',
                            elem: 'other-option-input',
                            elemMods: { hidden: 'yes' }
                        }
                    ],
                    mods: { clear: 'no' },
                    placeholder: hint,
                    content: [
                        {
                            elem: 'control',
                            mix: {
                                block: 'p-api-certification-request-edit',
                                elem: 'mark-control'
                            }
                        }
                    ]
                },

                errorMessage && {
                    block: 'p-api-certification-request-edit',
                    elem: 'error-message',
                    elemMods: {
                        type: 'error',
                        visibility: 'visible'
                    },
                    content: errorMessage
                }
            ])
        };
    })
);
