match(function() {
    return this.data.cmd === 'apiCertificationAddRequest' || this.data.cmd === 'apiCertificationEditRequest' ||
        this.data.cmd === 'apiCertificationUpgradeRequest';
})(

    block('app-main').mode('page-block')('p-api-certification-request-edit'),

    block('b-page').mode('title')(

        match(function() {
            return true;
        })(function() {
            return iget2(
                'p-api-certification-request-edit',
                'sozdanie-zayavki-na-poluchenie',
                'Создание заявки на получение доступа к Яндекс.Директ'
            );
        }),

        match(function() {
            return this.data.cmd === 'apiCertificationEditRequest';
        })(function() {
            return iget2(
                'p-api-certification-request-edit',
                'redaktirovanie-zayavki-na-poluchenie',
                'Редактирование заявки на получение доступа к Яндекс.Директ'
            );
        })
    )

);

block('p-api-certification-request-edit')(

    def()(function() {
        var isDataExist = !!this.data.request;

        return applyNext({
            isEditMode: this.data.cmd === 'apiCertificationEditRequest' ||
                this.data.cmd === 'apiCertificationUpgradeRequest',
            isDataExist: isDataExist,
            isOfferAccepted: this.data.api_offer == 'accepted',
            isAddMode: this.data.cmd === 'apiCertificationAddRequest',
            accessType: isDataExist ?
                u.escapeHTML(this.data.FORM.access_type || this.data.request.access_type) : false
        });
    }),

    content()(function() {
        var moreAboutApiUrl = u.formatUrl({
            protocol: 'https',
            host: 'tech.yandex.' + (this.data.lang.match(/en|tr/) ? 'com' : 'ru'),
            path: '/direct/'
        });

        return {
            block: 'l-page',
            mods: {
                layout: '60'
            },
            content: {
                elem: 'row',
                center: this.isOfferAccepted ?
                    [
                        this.isDataExist ?
                            [
                                {
                                    block: 'p-api-certification-request-edit',
                                    elem: 'header',
                                    isEdit: this.isEditMode,
                                    elemMods: {
                                        type: this.accessType
                                    }
                                },
                                {
                                    block: 'p-api-certification-request-edit',
                                    elem: 'form',
                                    js: {
                                        isAddMode: this.isAddMode
                                    },
                                    isEdit: this.isEditMode,
                                    action: this.data.SCRIPT,
                                    method: 'post',
                                    elemMods: {
                                        type: this.accessType
                                    }
                                }
                            ] :
                            {
                                block: 'p-api-certification-request-edit',
                                elem: 'access-denied',
                                content: iget2('p-api-certification-request-edit', 'net-prav-dlya-vypolneniya', 'Нет прав для выполнения операции')
                            }
                    ] :
                    {
                        block: 'p-api-certification-request-edit',
                        elem: 'settings',
                        content: [
                            {
                                elem: 'settings-title',
                                content: iget2('p-api-certification-request-edit', 'api-servisa-yandeks-direkt', 'API сервиса Яндекс.Директ')
                            },
                            {
                                elem: 'settings-text',
                                content: iget2(
                                    'p-api-certification-request-edit',
                                    'api-daet-vozmozhnost-razrabotchikam',
                                    'API дает возможность разработчикам создавать собственные программные приложения для работы с Яндекс.Директом. С его помощью можно эффективно управлять большим количеством рекламных кампаний, точнее прогнозировать бюджеты и своевременно получать статистические отчеты.'
                                )
                            },
                            {
                                elem: 'settings-faq',
                                content: [
                                    iget2('p-api-certification-request-edit', 'podrobnee-o-rabote-cherez', 'Подробнее о работе через API') + ': ',
                                    {
                                        block: 'link',
                                        content: moreAboutApiUrl,
                                        attrs: { target: '_blank' },
                                        url: moreAboutApiUrl
                                    }
                                ]
                            },
                            {
                                block: 'link',
                                mix: { block: 'p-api-certification-request-edit', elem: 'get-access-link' },
                                content: iget2('p-api-certification-request-edit', 'poluchit-dostup-k-api', 'Получить доступ к API'),
                                url: u.getUrl(
                                    'apiSettings',
                                    this.data.FORM.ulogin ?
                                        { api_welcome: 'yes', ulogin: u.escapeHTML(this.data.FORM.ulogin) } :
                                        { api_welcome: 'yes' })
                            }
                        ]
                    }
            }
        };
    })
);
