block('p-api-certification-request-show')(
    elem('field').elemMod('type', 'files-list').content()(function() {
        return [
            {
                elem: 'label',
                content: this.ctx.label
            }, {
                elem: 'list',
                tag: 'ul',
                content: this.ctx.value.specifications_and_screenshots.map(function(file) {
                    return {
                        elem: 'files-list-item',
                        tag: 'li',
                        content: [
                            file.name && file.name.toLowerCase().match('\.(jpg|png|gif|jpeg|bmp)$') && {
                                elem: 'files-list-preview',
                                image: u.getUrl('apiCertificationGetFile', {
                                    name: file.name,
                                    application_id: this.ctx.value.application_id,
                                    ulogin: this.ctx.value.ulogin
                                })
                            }, {
                                elem: 'files-list-data',
                                content: [{
                                    block: 'link',
                                    mix: {
                                        block: 'p-api-certification-request-show',
                                        elem: 'files-list-name'
                                    },
                                    content: u.escapeHTML(file.name),
                                    url: u.getUrl('apiCertificationGetFile', {
                                        name: file.name,
                                        application_id: this.ctx.value.application_id,
                                        ulogin: this.ctx.value.ulogin
                                    })
                                }, {
                                    elem: 'files-list-desc',
                                    content: u.hellipCut(u.escapeHTML(file.description), 200, '...')
                                }]
                            }
                        ]
                    };
                }, this)
            }
        ];
    }),

    elem('files-list-preview')(
        tag()('img'),
        attrs()(function() {
            return { src: this.ctx.image };
        })
    ),

    elem('files-list-item').content()(function() {
        return [
            applyNext(),
            { elem: 'clear' }
        ];
    })
);
