BEM.DOM.decl({ block: 'p-api-certification-request-show', elem: 'footer' }, {

    onSetMod: {
        js: function() {
            this.addCommentRequest = BEM.create('i-request_type_ajax', {
                url: 'main.pl?cmd=ajaxApiCertificationAddComment',
                cache: false,
                dataType: 'json'
            });

            this.setStatusRequest = BEM.create('i-request_type_ajax', {
                url: 'main.pl?cmd=ajaxApiCertificationSetStatus',
                cache: false,
                dataType: 'json'
            });

            u.graspSelf.call(this, {
                popup: 'popup on request-popup',
                popupButton: 'button on send-request',
                commentInput: 'input on comment-textarea'
            });

            this.popupButton.on('click', this._sendRequest, this);

            this.bindTo('request-popup-toggle', 'click', function(e) {
                this.popup.action = this.elemParams(e.data.domElem).action;
                this.popup.toggle(this);
            });
        }
    },

    _sendRequest: function() {
        var params = this.popup.params,
            comment = this.commentInput.val(),
            errMsg = iget2(
                'p-api-certification-request-show',
                'obrabotat-zayavku-ne-udalos',
                'Обработать заявку не удалось. Серверная ошибка, обратитесь к разработчикам'
            );

        if (comment.length) {
            this.addCommentRequest.get({
                application_id: params.appId,
                comment: u.escapeHTML(comment),
                ulogin: params.ulogin
            }, function() {
                this.setStatusRequest.get({
                    application_id: params.appId,
                    status: this.popup.action,
                    ulogin: params.ulogin
                }, function() {
                    this.popup.hide();
                    window.location.reload();
                }, function() {
                    BEM.blocks['b-confirm'].alert(errMsg);
                }, { callbackCtx: this });
            }, function() {
                BEM.blocks['b-confirm'].alert(errMsg);
            }, { callbackCtx: this });
        } else {
            BEM.blocks['b-confirm'].alert(iget2('p-api-certification-request-show', 'vvedite-tekst-kommentariya', 'Введите текст комментария'));
        }
    }
});
